/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpState;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.header.PollTimeoutHeader;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@Deprecated
public class PollMethod
extends DavMethodBase
implements ObservationConstants {
    private static Logger log = LoggerFactory.getLogger(PollMethod.class);
    private EventDiscovery eventDiscovery;

    public PollMethod(String uri, String subscriptionId) {
        this(uri, subscriptionId, 0L);
    }

    public PollMethod(String uri, String subscriptionId, long timeout) {
        super(uri);
        this.setRequestHeader("SubscriptionId", subscriptionId);
        if (timeout > 0L) {
            this.setRequestHeader(new PollTimeoutHeader(timeout));
        }
    }

    public EventDiscovery getResponseAsEventDiscovery() throws IOException, DavException {
        this.checkUsed();
        if (this.eventDiscovery != null) {
            return this.eventDiscovery;
        }
        DavException dx = this.getResponseException();
        if (dx != null) {
            throw dx;
        }
        throw new DavException(this.getStatusCode(), this.getName() + " resulted with unexpected status: " + this.getStatusLine());
    }

    @Override
    public String getName() {
        return "POLL";
    }

    @Override
    protected boolean isSuccess(int statusCode) {
        return 200 == statusCode;
    }

    @Override
    protected void processResponseBody(HttpState httpState, HttpConnection httpConnection) {
        if (this.getSuccess()) {
            try {
                this.setSuccess(this.buildDiscoveryFromRoot(this.getRootElement()));
            }
            catch (IOException e) {
                log.error("Error while parsing multistatus response: " + e);
                this.setSuccess(false);
            }
        }
    }

    private boolean buildDiscoveryFromRoot(Element root) {
        try {
            this.eventDiscovery = EventDiscovery.createFromXml(root);
            return true;
        }
        catch (IllegalArgumentException ex) {
            log.debug("Missing 'eventdiscovery' response body in POLL method.", ex);
            return false;
        }
    }
}

