/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

class ValueLoader {
    private final HttpClient client;
    private final HttpContext context;

    ValueLoader(HttpClient client, HttpContext context) {
        this.client = client;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadBinary(String uri, int index, Target target) throws RepositoryException, IOException {
        block4: {
            HttpGet request = new HttpGet(uri);
            try {
                HttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    target.setStream(response.getEntity().getContent());
                    break block4;
                }
                throw ExceptionConverter.generate(new DavException(statusCode, "Unable to load binary at " + uri + " - Status line = " + response.getStatusLine()));
            }
            finally {
                request.releaseConnection();
            }
        }
    }

    public Map<String, String> loadHeaders(String uri, String[] headerNames) throws IOException, RepositoryException {
        HttpHead request = new HttpHead(uri);
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HashMap<String, String> headers = new HashMap<String, String>();
                for (String name : headerNames) {
                    Header hdr = response.getFirstHeader(name);
                    if (hdr == null) continue;
                    headers.put(name, hdr.getValue());
                }
                HashMap<String, String> hashMap = headers;
                return hashMap;
            }
            throw ExceptionConverter.generate(new DavException(statusCode, "Unable to load headers at " + uri + " - Status line = " + response.getStatusLine().toString()));
        }
        finally {
            request.releaseConnection();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int loadType(String uri) throws RepositoryException, IOException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("type", ItemResourceConstants.NAMESPACE);
        HttpRequestBase request = null;
        try {
            request = new HttpPropfind(uri, nameSet, 0);
            HttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
            ((BaseDavRequest)request).checkSuccess(response);
            MultiStatusResponse[] responses = ((BaseDavRequest)request).getResponseBodyAsMultiStatus(response).getResponses();
            if (responses.length != 1) throw new ItemNotFoundException("Internal error. Cannot retrieve property type at " + uri);
            DavPropertySet props = responses[0].getProperties(200);
            DavProperty<?> type = props.get("type", ItemResourceConstants.NAMESPACE);
            if (type != null) {
                int n = PropertyType.valueFromName(type.getValue().toString());
                return n;
            }
            try {
                throw new RepositoryException("Internal error. Cannot retrieve property type at " + uri);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    static interface Target {
        public void setStream(InputStream var1) throws IOException;

        public void reset();
    }
}

