/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.iterator;

import java.util.Collection;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.EmptyIterator;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.jackrabbit.spi.commons.iterator.Predicate;
import org.apache.jackrabbit.spi.commons.iterator.Transformer;

public final class Iterators {
    private Iterators() {
    }

    public static <T> Iterator<T> singleton(T element) {
        return new SingletonIterator(element);
    }

    public static <T> Iterator<T> empty() {
        return EmptyIterator.INSTANCE;
    }

    public static <T> Iterator<T> iteratorChain(Iterator<? extends T> iterator1, Iterator<? extends T> iterator2) {
        return new IteratorChain(iterator1, iterator2);
    }

    public static <T> Iterator<T> iteratorChain(Iterator<? extends T>[] iterators) {
        return new IteratorChain(iterators);
    }

    public static <T> Iterator<T> iteratorChain(Collection<Iterator<? extends T>> iterators) {
        return new IteratorChain(iterators);
    }

    public static <T> Iterator<T> arrayIterator(T[] values, int from, int to) {
        return new ArrayIterator(values, from, to);
    }

    public static <T> Iterator<T> filterIterator(Iterator<? extends T> iterator, final Predicate<? super T> predicate) {
        return new FilterIterator(iterator, new org.apache.commons.collections.Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return predicate.evaluate(object);
            }
        });
    }

    public static <T, R, S extends T> Iterator<R> transformIterator(Iterator<? extends T> iterator, final Transformer<S, ? super R> transformer) {
        return new TransformIterator(iterator, new org.apache.commons.collections.Transformer(){

            @Override
            public Object transform(Object input) {
                return transformer.transform(input);
            }
        });
    }

    public static Iterator<Property> properties(PropertyIterator propertyIterator) {
        return propertyIterator;
    }

    public static Iterator<Node> nodes(NodeIterator nodeIterator) {
        return nodeIterator;
    }
}

