/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.rmi.client.ClientObject;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.client.RemoteRepositoryException;
import org.apache.jackrabbit.rmi.client.RemoteRuntimeException;
import org.apache.jackrabbit.rmi.remote.RemoteQuery;

public class ClientQuery
extends ClientObject
implements Query {
    private Session session;
    private RemoteQuery remote;

    public ClientQuery(Session session, RemoteQuery remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    @Override
    public QueryResult execute() throws RepositoryException {
        try {
            return this.getFactory().getQueryResult(this.session, this.remote.execute());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String getStatement() {
        try {
            return this.remote.getStatement();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public String getLanguage() {
        try {
            return this.remote.getLanguage();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public String getStoredQueryPath() throws RepositoryException {
        try {
            return this.remote.getStoredQueryPath();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public Node storeAsNode(String absPath) throws RepositoryException {
        try {
            return this.getNode(this.session, this.remote.storeAsNode(absPath));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void bindValue(String varName, Value value) throws RepositoryException {
        try {
            this.remote.bindValue(varName, value);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public String[] getBindVariableNames() throws RepositoryException {
        try {
            return this.remote.getBindVariableNames();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    @Override
    public void setLimit(long limit) {
        try {
            this.remote.setLimit(limit);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    @Override
    public void setOffset(long offset) {
        try {
            this.remote.setOffset(offset);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }
}

