/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.api.JackrabbitNodeTypeManager;
import org.apache.jackrabbit.commons.NamespaceHelper;
import org.apache.jackrabbit.commons.cnd.CompactNodeTypeDefReader;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistryListener;
import org.apache.jackrabbit.core.nodetype.xml.NodeTypeReader;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.commons.QNodeTypeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.nodetype.AbstractNodeTypeManager;
import org.apache.jackrabbit.spi.commons.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.spi.commons.nodetype.QDefinitionBuilderFactory;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NodeTypeManagerImpl
extends AbstractNodeTypeManager
implements JackrabbitNodeTypeManager,
NodeTypeRegistryListener {
    private final SessionContext context;
    private final NodeDefinitionImpl rootNodeDef;
    private final Map<Name, NodeTypeImpl> ntCache;
    private final Map<QPropertyDefinition, PropertyDefinitionImpl> pdCache;
    private final Map<QNodeDefinition, NodeDefinitionImpl> ndCache;
    private static final String APPLICATION_XML = "application/xml";

    public NodeTypeManagerImpl(SessionContext context) {
        this.context = context;
        this.ntCache = new ReferenceMap(0, 1);
        this.pdCache = new ReferenceMap(0, 1);
        this.ndCache = new ReferenceMap(0, 1);
        NodeTypeRegistry registry = context.getNodeTypeRegistry();
        this.rootNodeDef = new NodeDefinitionImpl(registry.getRootNodeDef(), this, context);
        this.ndCache.put(this.rootNodeDef.unwrap(), this.rootNodeDef);
        registry.addListener(this);
    }

    public void dispose() {
        this.context.getNodeTypeRegistry().removeListener(this);
    }

    public NodeDefinitionImpl getRootNodeDefinition() {
        return this.rootNodeDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeDefinitionImpl getNodeDefinition(QNodeDefinition def) {
        Map<QNodeDefinition, NodeDefinitionImpl> map = this.ndCache;
        synchronized (map) {
            NodeDefinitionImpl ndi = this.ndCache.get(def);
            if (ndi == null) {
                ndi = new NodeDefinitionImpl(def, this, this.context);
                this.ndCache.put(def, ndi);
            }
            return ndi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyDefinitionImpl getPropertyDefinition(QPropertyDefinition def) {
        Map<QPropertyDefinition, PropertyDefinitionImpl> map = this.pdCache;
        synchronized (map) {
            PropertyDefinitionImpl pdi = this.pdCache.get(def);
            if (pdi == null) {
                pdi = new PropertyDefinitionImpl(def, this, this.context, this.context.getValueFactory());
                this.pdCache.put(def, pdi);
            }
            return pdi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeTypeImpl getNodeType(Name name) throws NoSuchNodeTypeException {
        Map<Name, NodeTypeImpl> map = this.ntCache;
        synchronized (map) {
            NodeTypeImpl nt = this.ntCache.get(name);
            if (nt == null) {
                NodeTypeRegistry registry = this.context.getNodeTypeRegistry();
                EffectiveNodeType ent = registry.getEffectiveNodeType(name);
                QNodeTypeDefinition def = registry.getNodeTypeDef(name);
                nt = new NodeTypeImpl(ent, def, this, this.context, this.context.getValueFactory(), this.context.getDataStore());
                this.ntCache.put(name, nt);
            }
            return nt;
        }
    }

    @Override
    public NamePathResolver getNamePathResolver() {
        return this.context;
    }

    public NodeTypeRegistry getNodeTypeRegistry() {
        return this.context.getNodeTypeRegistry();
    }

    public NodeType[] registerNodeTypes(InputStream in, String contentType, boolean reregisterExisting) throws IOException, RepositoryException {
        this.context.getAccessManager().checkRepositoryPermission(8192);
        try {
            HashMap<String, String> namespaceMap = new HashMap<String, String>();
            ArrayList<QNodeTypeDefinition> nodeTypeDefs = new ArrayList<QNodeTypeDefinition>();
            if (contentType.equalsIgnoreCase("text/xml") || contentType.equalsIgnoreCase(APPLICATION_XML)) {
                try {
                    NodeTypeReader ntr = new NodeTypeReader(in);
                    Properties namespaces = ntr.getNamespaces();
                    if (namespaces != null) {
                        Enumeration<?> prefixes = namespaces.propertyNames();
                        while (prefixes.hasMoreElements()) {
                            String string = (String)prefixes.nextElement();
                            String uri = namespaces.getProperty(string);
                            namespaceMap.put(string, uri);
                        }
                    }
                    QNodeTypeDefinition[] defs = ntr.getNodeTypeDefs();
                    nodeTypeDefs.addAll(Arrays.asList(defs));
                }
                catch (NameException e) {
                    throw new RepositoryException("Illegal JCR name", e);
                }
            } else if (contentType.equalsIgnoreCase("text/x-jcr-cnd")) {
                try {
                    NamespaceMapping mapping = new NamespaceMapping(this.context.getSessionImpl());
                    CompactNodeTypeDefReader<QNodeTypeDefinition, NamespaceMapping> reader = new CompactNodeTypeDefReader<QNodeTypeDefinition, NamespaceMapping>(new InputStreamReader(in), "cnd input stream", mapping, new QDefinitionBuilderFactory());
                    namespaceMap.putAll(mapping.getPrefixToURIMapping());
                    for (QNodeTypeDefinition qNodeTypeDefinition : reader.getNodeTypeDefinitions()) {
                        nodeTypeDefs.add(qNodeTypeDefinition);
                    }
                }
                catch (ParseException e) {
                    IOException e2 = new IOException(e.getMessage());
                    e2.initCause(e);
                    throw e2;
                }
            } else {
                throw new UnsupportedRepositoryOperationException("Unsupported content type: " + contentType);
            }
            new NamespaceHelper(this.context.getSessionImpl()).registerNamespaces(namespaceMap);
            if (reregisterExisting) {
                NodeTypeRegistry registry = this.context.getNodeTypeRegistry();
                ArrayList<QNodeTypeDefinition> newNodeTypeDefs = new ArrayList<QNodeTypeDefinition>();
                ArrayList<QNodeTypeDefinition> registeredNodeTypeDefs = new ArrayList<QNodeTypeDefinition>();
                for (QNodeTypeDefinition nodeTypeDef : nodeTypeDefs) {
                    if (registry.isRegistered(nodeTypeDef.getName())) {
                        registeredNodeTypeDefs.add(nodeTypeDef);
                        continue;
                    }
                    newNodeTypeDefs.add(nodeTypeDef);
                }
                ArrayList<NodeType> arrayList = new ArrayList<NodeType>();
                arrayList.addAll(this.registerNodeTypes(newNodeTypeDefs));
                for (QNodeTypeDefinition nodeTypeDef : registeredNodeTypeDefs) {
                    registry.reregisterNodeType(nodeTypeDef);
                    arrayList.add(this.getNodeType(nodeTypeDef.getName()));
                }
                return arrayList.toArray(new NodeType[arrayList.size()]);
            }
            Collection<NodeType> types = this.registerNodeTypes(nodeTypeDefs);
            return types.toArray(new NodeType[types.size()]);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new RepositoryException("Invalid node type definition", e);
        }
    }

    @Override
    public void nodeTypeRegistered(Name ntName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeTypeReRegistered(Name ntName) {
        Iterator<ItemDefinitionImpl> iter;
        this.ntCache.remove(ntName);
        Map<QItemDefinition, ItemDefinitionImpl> map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = iter.next();
                if (!ntName.equals(pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!ntName.equals(nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeTypesUnregistered(Collection<Name> names) {
        Iterator<ItemDefinitionImpl> iter;
        for (Name name : names) {
            this.ntCache.remove(name);
        }
        Map<QNodeDefinition, NodeDefinitionImpl> map = this.pdCache;
        synchronized (map) {
            iter = this.pdCache.values().iterator();
            while (iter.hasNext()) {
                PropertyDefinitionImpl pd = iter.next();
                if (!names.contains(pd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
        map = this.ndCache;
        synchronized (map) {
            iter = this.ndCache.values().iterator();
            while (iter.hasNext()) {
                NodeDefinitionImpl nd = (NodeDefinitionImpl)iter.next();
                if (!names.contains(nd.unwrap().getDeclaringNodeType())) continue;
                iter.remove();
            }
        }
    }

    @Override
    public NodeTypeIterator getAllNodeTypes() throws RepositoryException {
        Object[] ntNames = this.context.getNodeTypeRegistry().getRegisteredNodeTypes();
        Arrays.sort(ntNames);
        ArrayList<NodeType> list = new ArrayList<NodeType>(ntNames.length);
        for (Object ntName : ntNames) {
            list.add(this.getNodeType((Name)ntName));
        }
        return new NodeTypeIteratorAdapter(list);
    }

    @Override
    public NodeTypeIterator getPrimaryNodeTypes() throws RepositoryException {
        Object[] ntNames = this.context.getNodeTypeRegistry().getRegisteredNodeTypes();
        Arrays.sort(ntNames);
        ArrayList<NodeType> list = new ArrayList<NodeType>(ntNames.length);
        for (Object ntName : ntNames) {
            NodeTypeImpl nt = this.getNodeType((Name)ntName);
            if (nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    @Override
    public NodeTypeIterator getMixinNodeTypes() throws RepositoryException {
        Object[] ntNames = this.context.getNodeTypeRegistry().getRegisteredNodeTypes();
        Arrays.sort(ntNames);
        ArrayList<NodeType> list = new ArrayList<NodeType>(ntNames.length);
        for (Object ntName : ntNames) {
            NodeTypeImpl nt = this.getNodeType((Name)ntName);
            if (!nt.isMixin()) continue;
            list.add(nt);
        }
        return new NodeTypeIteratorAdapter(list);
    }

    @Override
    public NodeType getNodeType(String nodeTypeName) throws NoSuchNodeTypeException {
        try {
            return this.getNodeType(this.context.getQName(nodeTypeName));
        }
        catch (NameException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, e);
        }
        catch (NamespaceException e) {
            throw new NoSuchNodeTypeException(nodeTypeName, e);
        }
    }

    private Collection<NodeType> registerNodeTypes(List<QNodeTypeDefinition> defs) throws InvalidNodeTypeDefException, RepositoryException {
        this.context.getNodeTypeRegistry().registerNodeTypes(defs);
        HashSet<NodeType> types = new HashSet<NodeType>();
        for (QNodeTypeDefinition def : defs) {
            try {
                types.add(this.getNodeType(def.getName()));
            }
            catch (NoSuchNodeTypeException noSuchNodeTypeException) {}
        }
        return types;
    }

    @Override
    public NodeType[] registerNodeTypes(InputSource in) throws SAXException, RepositoryException {
        try {
            return this.registerNodeTypes(in.getByteStream(), "text/xml");
        }
        catch (IOException e) {
            throw new SAXException("Error reading node type stream", e);
        }
    }

    @Override
    public NodeType[] registerNodeTypes(InputStream in, String contentType) throws IOException, RepositoryException {
        return this.registerNodeTypes(in, contentType, false);
    }

    @Override
    public boolean hasNodeType(String name) throws RepositoryException {
        try {
            Name qname = this.context.getQName(name);
            return this.getNodeTypeRegistry().isRegistered(qname);
        }
        catch (NamespaceException e) {
            return false;
        }
        catch (NameException e) {
            throw new RepositoryException("Invalid name: " + name, e);
        }
    }

    @Override
    public NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] definitions, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        this.context.getAccessManager().checkRepositoryPermission(8192);
        NodeTypeRegistry registry = this.context.getNodeTypeRegistry();
        ArrayList<QNodeTypeDefinition> addedDefs = new ArrayList<QNodeTypeDefinition>();
        ArrayList<QNodeTypeDefinition> modifiedDefs = new ArrayList<QNodeTypeDefinition>();
        for (NodeTypeDefinition definition : definitions) {
            QNodeTypeDefinition def = this.toNodeTypeDef(definition);
            if (registry.isRegistered(def.getName())) {
                if (allowUpdate) {
                    modifiedDefs.add(def);
                    continue;
                }
                throw new NodeTypeExistsException(definition.getName());
            }
            addedDefs.add(def);
        }
        try {
            ArrayList<NodeType> result = new ArrayList<NodeType>();
            result.addAll(this.registerNodeTypes(addedDefs));
            for (QNodeTypeDefinition nodeTypeDef : modifiedDefs) {
                registry.reregisterNodeType(nodeTypeDef);
                result.add(this.getNodeType(nodeTypeDef.getName()));
            }
            return new NodeTypeIteratorAdapter(result);
        }
        catch (InvalidNodeTypeDefException e) {
            throw new InvalidNodeTypeDefinitionException(e.getMessage(), e);
        }
    }

    @Override
    public void unregisterNodeTypes(String[] names) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        this.context.getAccessManager().checkRepositoryPermission(8192);
        HashSet<Name> ntNames = new HashSet<Name>();
        for (String name : names) {
            try {
                ntNames.add(this.context.getQName(name));
            }
            catch (NamespaceException e) {
                throw new RepositoryException("Invalid name: " + name, e);
            }
            catch (NameException e) {
                throw new RepositoryException("Invalid name: " + name, e);
            }
        }
        this.getNodeTypeRegistry().unregisterNodeTypes(ntNames);
    }

    private QNodeTypeDefinition toNodeTypeDef(NodeTypeDefinition definition) throws RepositoryException {
        return new QNodeTypeDefinitionImpl(definition, this.context, QValueFactoryImpl.getInstance());
    }

    public String toString() {
        return "NodeTypeManager(" + super.toString() + ")\n" + this.context.getNodeTypeRegistry();
    }
}

