/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.DatabaseRecordIterator;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.util.db.CheckSchemaOperation;
import org.apache.jackrabbit.core.util.db.ConnectionFactory;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DatabaseAware;
import org.apache.jackrabbit.core.util.db.DbUtility;
import org.apache.jackrabbit.core.util.db.StreamWrapper;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseJournal
extends AbstractJournal
implements DatabaseAware {
    private static final String DEFAULT_JOURNAL_TABLE = "JOURNAL";
    private static final String LOCAL_REVISIONS_TABLE = "LOCAL_REVISIONS";
    static Logger log = LoggerFactory.getLogger(DatabaseJournal.class);
    private String driver;
    private String url;
    private String databaseType;
    private String user;
    private String password;
    private String dataSourceName;
    ConnectionHelper conHelper;
    private int lockLevel;
    private long lockedRevision;
    private boolean janitorEnabled = false;
    int janitorSleep = 86400;
    Calendar janitorNextRun = Calendar.getInstance();
    private Thread janitorThread;
    private boolean schemaCheckEnabled;
    private DatabaseRevision databaseRevision;
    protected String selectRevisionsStmtSQL;
    protected String updateGlobalStmtSQL;
    protected String selectGlobalStmtSQL;
    protected String insertRevisionStmtSQL;
    protected String selectMinLocalRevisionStmtSQL;
    protected String cleanRevisionStmtSQL;
    protected String getLocalRevisionStmtSQL;
    protected String insertLocalRevisionStmtSQL;
    protected String updateLocalRevisionStmtSQL;
    protected String schemaObjectPrefix;
    private ConnectionFactory connectionFactory;

    public DatabaseJournal() {
        if (this.janitorNextRun.get(11) >= 3) {
            this.janitorNextRun.add(5, 1);
        }
        this.janitorNextRun.set(11, 3);
        this.janitorNextRun.set(12, 0);
        this.janitorNextRun.set(13, 0);
        this.janitorNextRun.set(14, 0);
        this.schemaCheckEnabled = true;
        this.databaseType = "default";
        this.schemaObjectPrefix = "";
    }

    @Override
    public void setConnectionFactory(ConnectionFactory connnectionFactory) {
        this.connectionFactory = connnectionFactory;
    }

    @Override
    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        this.init();
        try {
            this.conHelper = this.createConnectionHelper(this.getDataSource());
            this.schemaObjectPrefix = this.conHelper.prepareDbIdentifier(this.schemaObjectPrefix);
            if (this.isSchemaCheckEnabled()) {
                this.createCheckSchemaOperation().run();
            }
            if (this.isSchemaCheckEnabled()) {
                this.checkLocalRevisionSchema();
            }
            this.buildSQLStatements();
            this.initInstanceRevisionAndJanitor();
        }
        catch (Exception e) {
            String msg = "Unable to create connection.";
            throw new JournalException(msg, e);
        }
        log.info("DatabaseJournal initialized.");
    }

    private DataSource getDataSource() throws Exception {
        if (this.getDataSourceName() == null || "".equals(this.getDataSourceName())) {
            return this.connectionFactory.getDataSource(this.getDriver(), this.getUrl(), this.getUser(), this.getPassword());
        }
        return this.connectionFactory.getDataSource(this.dataSourceName);
    }

    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new ConnectionHelper(dataSrc, false);
    }

    protected CheckSchemaOperation createCheckSchemaOperation() {
        InputStream in = DatabaseJournal.class.getResourceAsStream(this.databaseType + ".ddl");
        return new CheckSchemaOperation(this.conHelper, in, this.schemaObjectPrefix + DEFAULT_JOURNAL_TABLE).addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix);
    }

    protected void init() throws JournalException {
        if (this.driver == null && this.dataSourceName == null) {
            String msg = "Driver not specified.";
            throw new JournalException(msg);
        }
        if (this.url == null && this.dataSourceName == null) {
            String msg = "Connection URL not specified.";
            throw new JournalException(msg);
        }
        if (this.dataSourceName != null) {
            try {
                String configuredDatabaseType = this.connectionFactory.getDataBaseType(this.dataSourceName);
                if (DatabaseJournal.class.getResourceAsStream(configuredDatabaseType + ".ddl") != null) {
                    this.setDatabaseType(configuredDatabaseType);
                }
            }
            catch (RepositoryException e) {
                throw new JournalException("failed to get database type", e);
            }
        }
        if (this.databaseType == null) {
            try {
                this.databaseType = DatabaseJournal.getDatabaseTypeFromURL(this.url);
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to derive database type from URL: " + e.getMessage();
                throw new JournalException(msg);
            }
        }
    }

    protected void initInstanceRevisionAndJanitor() throws Exception {
        this.databaseRevision = new DatabaseRevision();
        long localFileRevision = 0L;
        if (this.getRevision() != null) {
            FileRevision currentFileRevision = new FileRevision(new File(this.getRevision()), true);
            localFileRevision = currentFileRevision.get();
            currentFileRevision.close();
        }
        long localRevision = this.databaseRevision.init(localFileRevision);
        log.info("Initialized local revision to " + localRevision);
        if (this.janitorEnabled) {
            this.janitorThread = new Thread((Runnable)new RevisionTableJanitor(), "Jackrabbit-ClusterRevisionJanitor");
            this.janitorThread.setDaemon(true);
            this.janitorThread.start();
            log.info("Cluster revision janitor thread started; first run scheduled at " + this.janitorNextRun.getTime());
        } else {
            log.info("Cluster revision janitor thread not started");
        }
    }

    @Override
    public InstanceRevision getInstanceRevision() throws JournalException {
        return this.databaseRevision;
    }

    private static String getDatabaseTypeFromURL(String url) throws IllegalArgumentException {
        int end;
        int start = url.indexOf(58);
        if (start != -1 && (end = url.indexOf(58, start + 1)) != -1) {
            return url.substring(start + 1, end);
        }
        throw new IllegalArgumentException(url);
    }

    @Override
    public RecordIterator getRecords(long startRevision) throws JournalException {
        try {
            return new DatabaseRecordIterator(this.conHelper.exec(this.selectRevisionsStmtSQL, new Object[]{new Long(startRevision)}, false, 0), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            throw new JournalException("Unable to return record iterator.", e);
        }
    }

    @Override
    public RecordIterator getRecords() throws JournalException {
        try {
            return new DatabaseRecordIterator(this.conHelper.exec(this.selectRevisionsStmtSQL, new Object[]{new Long(Long.MIN_VALUE)}, false, 0), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            throw new JournalException("Unable to return record iterator.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSync(long startRevision, boolean startup) throws JournalException {
        if (!startup) {
            this.doSync(startRevision);
        } else {
            try {
                this.startBatch();
                try {
                    this.doSync(startRevision);
                }
                finally {
                    this.endBatch(true);
                }
            }
            catch (SQLException e) {
                throw new JournalException("Couldn't sync the cluster node", e);
            }
        }
    }

    @Override
    protected void doLock() throws JournalException {
        ResultSet rs = null;
        boolean succeeded = false;
        try {
            this.startBatch();
        }
        catch (SQLException e) {
            throw new JournalException("Unable to set autocommit to false.", e);
        }
        try {
            this.conHelper.exec(this.updateGlobalStmtSQL, new Object[0]);
            rs = this.conHelper.exec(this.selectGlobalStmtSQL, (Object[])null, false, 0);
            if (!rs.next()) {
                throw new JournalException("No revision available.");
            }
            this.lockedRevision = rs.getLong(1);
            succeeded = true;
        }
        catch (SQLException e) {
            try {
                throw new JournalException("Unable to lock global revision table.", e);
            }
            catch (Throwable throwable) {
                DbUtility.close(rs);
                if (!succeeded) {
                    this.doUnlock(false);
                }
                throw throwable;
            }
        }
        DbUtility.close(rs);
        if (!succeeded) {
            this.doUnlock(false);
        }
    }

    @Override
    protected void doUnlock(boolean successful) {
        this.endBatch(successful);
    }

    private void startBatch() throws SQLException {
        if (this.lockLevel++ == 0) {
            this.conHelper.startBatch();
        }
    }

    private void endBatch(boolean successful) {
        if (--this.lockLevel == 0) {
            try {
                this.conHelper.endBatch(successful);
            }
            catch (SQLException e) {
                log.error("failed to end batch", e);
            }
        }
    }

    @Override
    protected void appending(AppendRecord record) {
        record.setRevision(this.lockedRevision);
    }

    @Override
    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        try {
            this.conHelper.exec(this.insertRevisionStmtSQL, record.getRevision(), this.getId(), record.getProducerId(), new StreamWrapper(in, length));
        }
        catch (SQLException e) {
            String msg = "Unable to append revision " + this.lockedRevision + ".";
            throw new JournalException(msg, e);
        }
    }

    @Override
    public void close() {
        if (this.janitorThread != null) {
            this.janitorThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLocalRevisionSchema() throws Exception {
        ByteArrayInputStream localRevisionDDLStream = null;
        InputStream in = DatabaseJournal.class.getResourceAsStream(this.databaseType + ".ddl");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String sql = reader.readLine();
            while (sql != null) {
                if (!sql.startsWith("#") && sql.length() > 0 && sql.indexOf(LOCAL_REVISIONS_TABLE) != -1) {
                    localRevisionDDLStream = new ByteArrayInputStream(sql.getBytes());
                    break;
                }
                sql = reader.readLine();
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        new CheckSchemaOperation(this.conHelper, localRevisionDDLStream, this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE).addVariableReplacement("${schemaObjectPrefix}", this.schemaObjectPrefix).run();
    }

    protected void buildSQLStatements() {
        this.selectRevisionsStmtSQL = "select REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID > ? order by REVISION_ID";
        this.updateGlobalStmtSQL = "update " + this.schemaObjectPrefix + "GLOBAL_REVISION set REVISION_ID = REVISION_ID + 1";
        this.selectGlobalStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "GLOBAL_REVISION";
        this.insertRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "JOURNAL (REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA) values (?,?,?,?)";
        this.selectMinLocalRevisionStmtSQL = "select MIN(REVISION_ID) from " + this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE;
        this.cleanRevisionStmtSQL = "delete from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID < ?";
        this.getLocalRevisionStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "LOCAL_REVISIONS where JOURNAL_ID = ?";
        this.insertLocalRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "LOCAL_REVISIONS (REVISION_ID, JOURNAL_ID) values (?,?)";
        this.updateLocalRevisionStmtSQL = "update " + this.schemaObjectPrefix + "LOCAL_REVISIONS set REVISION_ID = ? where JOURNAL_ID = ?";
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getSchema() {
        return this.databaseType;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getJanitorEnabled() {
        return this.janitorEnabled;
    }

    public int getJanitorSleep() {
        return this.janitorSleep;
    }

    public int getJanitorFirstRunHourOfDay() {
        return this.janitorNextRun.get(11);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setSchema(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJanitorEnabled(boolean enabled) {
        this.janitorEnabled = enabled;
    }

    public void setJanitorSleep(int sleep) {
        this.janitorSleep = sleep;
    }

    public void setJanitorFirstRunHourOfDay(int hourOfDay) {
        this.janitorNextRun = Calendar.getInstance();
        if (this.janitorNextRun.get(11) >= hourOfDay) {
            this.janitorNextRun.add(5, 1);
        }
        this.janitorNextRun.set(11, hourOfDay);
        this.janitorNextRun.set(12, 0);
        this.janitorNextRun.set(13, 0);
        this.janitorNextRun.set(14, 0);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public final boolean isSchemaCheckEnabled() {
        return this.schemaCheckEnabled;
    }

    public final void setSchemaCheckEnabled(boolean enabled) {
        this.schemaCheckEnabled = enabled;
    }

    public class RevisionTableJanitor
    implements Runnable {
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    log.info("Next clean-up run scheduled at " + DatabaseJournal.this.janitorNextRun.getTime());
                    long sleepTime = DatabaseJournal.this.janitorNextRun.getTimeInMillis() - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    this.cleanUpOldRevisions();
                    DatabaseJournal.this.janitorNextRun.add(13, DatabaseJournal.this.janitorSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            log.info("Interrupted: stopping clean-up task.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanUpOldRevisions() {
            ResultSet rs = null;
            try {
                long minRevision = 0L;
                rs = DatabaseJournal.this.conHelper.exec(DatabaseJournal.this.selectMinLocalRevisionStmtSQL, (Object[])null, false, 0);
                boolean cleanUp = rs.next();
                if (cleanUp) {
                    minRevision = rs.getLong(1);
                }
                if (cleanUp) {
                    DatabaseJournal.this.conHelper.exec(DatabaseJournal.this.cleanRevisionStmtSQL, minRevision);
                    log.info("Cleaned old revisions up to revision " + minRevision + ".");
                }
                DbUtility.close(rs);
            }
            catch (Exception e) {
                log.warn("Failed to clean up old revisions.", e);
            }
            finally {
                DbUtility.close(rs);
            }
        }
    }

    public class DatabaseRevision
    implements InstanceRevision {
        private long localRevision;
        private boolean initialized = false;

        protected synchronized long init(long revision) throws JournalException {
            long l;
            ResultSet rs = null;
            try {
                rs = DatabaseJournal.this.conHelper.exec(DatabaseJournal.this.getLocalRevisionStmtSQL, new Object[]{DatabaseJournal.this.getId()}, false, 0);
                boolean exists = rs.next();
                if (exists) {
                    revision = rs.getLong(1);
                }
                if (!exists) {
                    DatabaseJournal.this.conHelper.exec(DatabaseJournal.this.insertLocalRevisionStmtSQL, revision, DatabaseJournal.this.getId());
                }
                this.localRevision = revision;
                this.initialized = true;
                l = revision;
            }
            catch (SQLException e) {
                try {
                    log.warn("Failed to initialize local revision.", e);
                    throw new JournalException("Failed to initialize local revision", e);
                }
                catch (Throwable throwable) {
                    DbUtility.close(rs);
                    throw throwable;
                }
            }
            DbUtility.close(rs);
            return l;
        }

        @Override
        public synchronized long get() {
            if (!this.initialized) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            return this.localRevision;
        }

        @Override
        public synchronized void set(long localRevision) throws JournalException {
            if (!this.initialized) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            try {
                DatabaseJournal.this.conHelper.exec(DatabaseJournal.this.updateLocalRevisionStmtSQL, localRevision, DatabaseJournal.this.getId());
                this.localRevision = localRevision;
            }
            catch (SQLException e) {
                log.warn("Failed to update local revision.", e);
                throw new JournalException("Failed to update local revision.", e);
            }
        }

        @Override
        public void close() {
        }
    }
}

