/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.servlet;

import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import com.uwyn.jhighlight.tools.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class HighlightFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest http_request = (HttpServletRequest)request;
            HttpServletResponse http_response = (HttpServletResponse)response;
            Renderer renderer = null;
            String uri = http_request.getRequestURI();
            String extension = FileUtils.getExtension(uri);
            if (extension != null && extension.endsWith("s")) {
                renderer = XhtmlRendererFactory.getRenderer(extension.substring(0, extension.length() - 1));
            }
            if (renderer != null) {
                SourceRequestWrapper request_wrapper = new SourceRequestWrapper(http_request);
                CharResponseWrapper response_wrapper = new CharResponseWrapper(http_response);
                chain.doFilter(request_wrapper, response_wrapper);
                ServletOutputStream out = response.getOutputStream();
                try {
                    if (200 == response_wrapper.getStatus()) {
                        ByteArrayInputStream is = new ByteArrayInputStream(response_wrapper.getWrappedOutputStream().toByteArray());
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        String encoding = request.getCharacterEncoding();
                        if (null == encoding) {
                            encoding = "UTF-8";
                        }
                        String name = http_request.getServletPath().substring(1);
                        name = name.substring(0, name.length() - 1);
                        renderer.highlight(name, is, os, encoding, false);
                        String highlighted = os.toString("ISO-8859-1");
                        response.setContentType("text/html");
                        response.setContentLength(highlighted.length());
                        out.write(highlighted.getBytes("ISO-8859-1"));
                    }
                    out.write(response_wrapper.getWrappedOutputStream().toByteArray());
                }
                finally {
                    out.close();
                }
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private static class ServletOutputStreamWrapper
    extends ServletOutputStream {
        protected ByteArrayOutputStream mOutput = new ByteArrayOutputStream();

        @Override
        public void write(int b) throws IOException {
            this.mOutput.write(b);
        }

        public byte[] toByteArray() {
            return this.mOutput.toByteArray();
        }
    }

    private static class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private ServletOutputStreamWrapper mOutput = new ServletOutputStreamWrapper();
        private int mStatus = 200;

        public ServletOutputStreamWrapper getWrappedOutputStream() {
            return this.mOutput;
        }

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            return this.mOutput;
        }

        @Override
        public void setStatus(int status) {
            this.mStatus = status;
            super.setStatus(status);
        }

        @Override
        public void sendError(int status, String msg) throws IOException {
            this.mStatus = status;
            super.sendError(status, msg);
        }

        @Override
        public void sendError(int status) throws IOException {
            this.mStatus = status;
            super.sendError(status);
        }

        @Override
        public int getStatus() {
            return this.mStatus;
        }
    }

    private static class SourceRequestWrapper
    extends HttpServletRequestWrapper {
        public SourceRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        @Override
        public String getServletPath() {
            String path = super.getServletPath();
            return path.substring(0, path.length() - 1);
        }

        @Override
        public String getPathTranslated() {
            String path = super.getPathTranslated();
            return path.substring(0, path.length() - 1);
        }

        @Override
        public String getRequestURI() {
            String uri = super.getRequestURI();
            return uri.substring(0, uri.length() - 1);
        }

        @Override
        public StringBuffer getRequestURL() {
            StringBuffer url = super.getRequestURL();
            url.setLength(url.length() - 1);
            return url;
        }
    }
}

