/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.util.LinkResolver;
import com.healthmarketscience.jackcess.util.MemFileChannel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Random;

public abstract class CustomLinkResolver
implements LinkResolver {
    private static final Random DB_ID = new Random();
    private static final String MEM_DB_PREFIX = "memdb_";
    private static final String FILE_DB_PREFIX = "linkeddb_";
    public static final Database.FileFormat DEFAULT_FORMAT = Database.FileFormat.V2000;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final File DEFAULT_TEMP_DIR = null;
    private final Database.FileFormat _defaultFormat;
    private final boolean _defaultInMemory;
    private final File _defaultTempDir;

    protected CustomLinkResolver() {
        this(DEFAULT_FORMAT, false, DEFAULT_TEMP_DIR);
    }

    protected CustomLinkResolver(Database.FileFormat defaultFormat, boolean defaultInMemory, File defaultTempDir) {
        this._defaultFormat = defaultFormat;
        this._defaultInMemory = defaultInMemory;
        this._defaultTempDir = defaultTempDir;
    }

    protected Database.FileFormat getDefaultFormat() {
        return this._defaultFormat;
    }

    protected boolean isDefaultInMemory() {
        return this._defaultInMemory;
    }

    protected File getDefaultTempDirectory() {
        return this._defaultTempDir;
    }

    public Database resolveLinkedDatabase(Database linkerDb, String linkeeFileName) throws IOException {
        Object customFile = this.loadCustomFile(linkerDb, linkeeFileName);
        if (customFile != null) {
            return this.createTempDb(customFile, this.getDefaultFormat(), this.isDefaultInMemory(), this.getDefaultTempDirectory());
        }
        return LinkResolver.DEFAULT.resolveLinkedDatabase(linkerDb, linkeeFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Database createTempDb(Object customFile, Database.FileFormat format, boolean inMemory, File tempDir) throws IOException {
        TempDatabaseImpl tempDatabaseImpl;
        block5: {
            File dbFile = null;
            FileChannel channel = null;
            boolean success = false;
            try {
                if (inMemory) {
                    dbFile = new File(MEM_DB_PREFIX + DB_ID.nextLong() + format.getFileExtension());
                    channel = MemFileChannel.newChannel();
                } else {
                    dbFile = File.createTempFile(FILE_DB_PREFIX, format.getFileExtension(), tempDir);
                    channel = new RandomAccessFile(dbFile, "rw").getChannel();
                }
                TempDatabaseImpl.initDbChannel(channel, format);
                TempDatabaseImpl db = new TempDatabaseImpl(this, customFile, dbFile, channel, format);
                success = true;
                tempDatabaseImpl = db;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ByteUtil.closeQuietly(channel);
                    CustomLinkResolver.deleteDbFile(dbFile);
                    CustomLinkResolver.closeCustomFile(customFile);
                }
                throw throwable;
            }
            ByteUtil.closeQuietly(channel);
            CustomLinkResolver.deleteDbFile(dbFile);
            CustomLinkResolver.closeCustomFile(customFile);
        }
        return tempDatabaseImpl;
    }

    private static void deleteDbFile(File dbFile) {
        if (dbFile != null && dbFile.getName().startsWith(FILE_DB_PREFIX)) {
            dbFile.delete();
        }
    }

    private static void closeCustomFile(Object customFile) {
        if (customFile instanceof Closeable) {
            ByteUtil.closeQuietly((Closeable)customFile);
        }
    }

    protected abstract Object loadCustomFile(Database var1, String var2) throws IOException;

    protected abstract boolean loadCustomTable(Database var1, Object var2, String var3) throws IOException;

    private static class TempDatabaseImpl
    extends DatabaseImpl {
        private final CustomLinkResolver _resolver;
        private final Object _customFile;

        protected TempDatabaseImpl(CustomLinkResolver resolver, Object customFile, File file, FileChannel channel, Database.FileFormat fileFormat) throws IOException {
            super(file, channel, true, false, fileFormat, null, null, null);
            this._resolver = resolver;
            this._customFile = customFile;
        }

        protected TableImpl getTable(String name, boolean includeSystemTables) throws IOException {
            TableImpl table = super.getTable(name, includeSystemTables);
            if (table == null && this._resolver.loadCustomTable(this, this._customFile, name)) {
                table = super.getTable(name, includeSystemTables);
            }
            return table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                CustomLinkResolver.deleteDbFile(this.getFile());
                CustomLinkResolver.closeCustomFile(this._customFile);
            }
        }

        static FileChannel initDbChannel(FileChannel channel, Database.FileFormat format) throws IOException {
            DatabaseImpl.FileFormatDetails details = TempDatabaseImpl.getFileFormatDetails(format);
            TempDatabaseImpl.transferDbFrom(channel, TempDatabaseImpl.getResourceAsStream(details.getEmptyFilePath()));
            return channel;
        }
    }
}

