/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.vfs2.provider.rar;

import com.github.junrar.Archive;
import com.github.junrar.Volume;
import com.github.junrar.io.IReadOnlyAccess;
import com.github.junrar.io.InputStreamReadOnlyAccessFile;
import com.github.junrar.vfs2.provider.rar.RandomAccessContentAccess;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class VFSVolume
implements Volume {
    private final Archive archive;
    private final FileObject file;

    public VFSVolume(Archive archive, FileObject file) {
        this.archive = archive;
        this.file = file;
    }

    @Override
    public IReadOnlyAccess getReadOnlyAccess() throws IOException {
        IReadOnlyAccess input = null;
        try {
            RandomAccessContent rac = this.file.getContent().getRandomAccessContent(RandomAccessMode.READ);
            input = new RandomAccessContentAccess(rac);
        }
        catch (Exception e) {
            input = new InputStreamReadOnlyAccessFile(this.file.getContent().getInputStream());
        }
        return input;
    }

    @Override
    public long getLength() {
        try {
            return this.file.getContent().getSize();
        }
        catch (FileSystemException e) {
            return -1L;
        }
    }

    @Override
    public Archive getArchive() {
        return this.archive;
    }

    public FileObject getFile() {
        return this.file;
    }
}

