/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.modification;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModFileManagement;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class PartitionLevelModFileManager
implements ModFileManagement {
    private final int levelModFileNumThreshold = 30;
    private final long singleModFileSizeThresholdByte = 16384L;
    private final Map<Long, TreeMap<Long, ModificationFile>> levelModFileIdMap = new HashMap<Long, TreeMap<Long, ModificationFile>>();
    private final Map<ModificationFile, Set<TsFileResource>> modFileReferences = new HashMap<ModificationFile, Set<TsFileResource>>();

    @Override
    public synchronized ModificationFile recover(String modFilePath, TsFileResource tsFileResource) throws IOException {
        long[] levelAndModFileId = ModificationFile.parseFileName(new File(modFilePath).getName());
        long level = levelAndModFileId[0];
        long modFileId = levelAndModFileId[1];
        TreeMap idModificationMap = this.levelModFileIdMap.computeIfAbsent(level, l -> new TreeMap());
        ModificationFile modificationFile = idModificationMap.computeIfAbsent(modFileId, id -> new ModificationFile(new File(modFilePath), true));
        this.modFileReferences.computeIfAbsent(modificationFile, f -> new HashSet()).add(tsFileResource);
        return modificationFile;
    }

    @Override
    public ModificationFile allocateFor(TsFileResource tsFileResource) throws IOException {
        TsFileResource prev = tsFileResource.getPrev();
        TsFileResource next = tsFileResource.getNext();
        while (prev != null || next != null) {
            ModificationFile sharedModFile;
            if (prev != null) {
                sharedModFile = prev.getSharedModFile();
                if (sharedModFile != null) {
                    if (this.tryShare(sharedModFile, prev, tsFileResource)) {
                        return sharedModFile;
                    }
                    prev = null;
                } else {
                    prev = prev.getPrev();
                }
            }
            if (next == null) continue;
            sharedModFile = next.getSharedModFile();
            if (sharedModFile != null) {
                if (this.tryShare(sharedModFile, next, tsFileResource)) {
                    return sharedModFile;
                }
                next = null;
                continue;
            }
            next = next.getNext();
        }
        return this.allocateNew(tsFileResource);
    }

    private synchronized boolean tryShare(ModificationFile sharedModFile, TsFileResource modFileHolder, TsFileResource toAllocate) throws IOException {
        Set<TsFileResource> references = this.modFileReferences.get(sharedModFile);
        if (references.isEmpty()) {
            return false;
        }
        long level = modFileHolder.getTsFileID().compactionVersion;
        TreeMap<Long, ModificationFile> idModificationMap = this.levelModFileIdMap.get(level);
        if (idModificationMap.size() > 30) {
            references.add(toAllocate);
            return true;
        }
        if (sharedModFile.getFileLength() < 16384L) {
            references.add(toAllocate);
            return true;
        }
        return false;
    }

    private synchronized ModificationFile allocateNew(TsFileResource tsFileResource) {
        long level = tsFileResource.getTsFileID().getInnerCompactionCount();
        TreeMap idModificationMap = this.levelModFileIdMap.computeIfAbsent(level, l -> new TreeMap());
        long newId = idModificationMap.isEmpty() ? 1L : (Long)idModificationMap.lastEntry().getKey() + 1L;
        ModificationFile newModFile = new ModificationFile(new File(tsFileResource.getTsFile().getParentFile(), ModificationFile.composeFileName(level, newId)), true);
        idModificationMap.put(newId, newModFile);
        HashSet<TsFileResource> references = new HashSet<TsFileResource>();
        references.add(tsFileResource);
        this.modFileReferences.put(newModFile, references);
        return newModFile;
    }

    @Override
    public synchronized void releaseFor(TsFileResource tsFileResource, ModificationFile modificationFile) throws IOException {
        Set<TsFileResource> references = this.modFileReferences.get(modificationFile);
        references.remove(tsFileResource);
        if (references.isEmpty()) {
            this.modFileReferences.remove(modificationFile);
            modificationFile.remove();
        }
    }

    @Override
    public synchronized void addReference(TsFileResource tsFileResource, ModificationFile modificationFile) {
        this.modFileReferences.computeIfAbsent(modificationFile, f -> new HashSet()).add(tsFileResource);
    }
}

