/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBTreePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.source.IoTDBSource;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.metric.overview.PipeTsFileToTabletsMetrics;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionSourceMetrics;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.source.dataregion.DataRegionWatermarkInjector;
import org.apache.iotdb.db.pipe.source.dataregion.historical.PipeHistoricalDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.historical.PipeHistoricalDataRegionTsFileAndDeletionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionHeartbeatSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionHybridSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionLogSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionTsFileSource;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.annotation.TableModel;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TreeModel
@TableModel
public class IoTDBDataRegionSource
extends IoTDBSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionSource.class);
    private PipeHistoricalDataRegionSource historicalExtractor;
    private PipeRealtimeDataRegionSource realtimeExtractor;
    private DataRegionWatermarkInjector watermarkInjector;
    private boolean hasNoExtractionNeed = true;
    private boolean shouldExtractDeletion = false;

    public void validate(PipeParameterValidator validator) throws Exception {
        boolean isTableModelDataAllowedToBeCaptured;
        super.validate(validator);
        boolean forwardingPipeRequests = validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.forwarding-pipe-requests", "source.forwarding-pipe-requests"), true);
        if (!forwardingPipeRequests) {
            throw new PipeParameterNotValidException(String.format("The parameter %s cannot be set to false.", "source.forwarding-pipe-requests"));
        }
        boolean isTreeDialect = validator.getParameters().getStringOrDefault("__system.sql-dialect", "tree").equals("tree");
        boolean isCaptureTree = validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.capture.tree", "source.capture.tree"), isTreeDialect);
        boolean isCaptureTable = validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.capture.table", "source.capture.table"), !isTreeDialect);
        if (!isCaptureTree && !isCaptureTable) {
            throw new PipeParameterNotValidException("capture.tree and capture.table can not both be specified as false");
        }
        boolean isDoubleLiving = validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.mode.double-living", "source.mode.double-living"), false);
        boolean isTreeModelDataAllowedToBeCaptured = isDoubleLiving || isCaptureTree;
        boolean bl = isTableModelDataAllowedToBeCaptured = isDoubleLiving || isCaptureTable;
        if (!isTreeModelDataAllowedToBeCaptured && validator.getParameters().hasAnyAttributes(new String[]{"extractor.path", "source.path", "extractor.pattern", "source.pattern"})) {
            throw new PipeException("The pipe cannot extract tree model data when sql dialect is set to table.");
        }
        if (!isTableModelDataAllowedToBeCaptured && validator.getParameters().hasAnyAttributes(new String[]{"extractor.database-name", "source.database-name", "extractor.table-name", "source.table-name", "extractor.database", "source.database", "extractor.table", "source.table"})) {
            throw new PipeException("The pipe cannot extract table model data when sql dialect is set to tree.");
        }
        Pair<Boolean, Boolean> insertionDeletionListeningOptionPair = DataRegionListeningFilter.parseInsertionDeletionListeningOptionPair(validator.getParameters());
        if (((Boolean)insertionDeletionListeningOptionPair.getLeft()).equals(false) && ((Boolean)insertionDeletionListeningOptionPair.getRight()).equals(false)) {
            return;
        }
        this.hasNoExtractionNeed = false;
        this.shouldExtractDeletion = (Boolean)insertionDeletionListeningOptionPair.getRight();
        if (((Boolean)insertionDeletionListeningOptionPair.getLeft()).equals(true) && IoTDBDescriptor.getInstance().getConfig().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            throw new PipeException("The pipe cannot transfer data when data region is using ratis consensus.");
        }
        validator.validateAttributeValueRange("extractor.pattern.format", true, new String[]{"prefix", "iotdb"}).validateAttributeValueRange("source.pattern.format", true, new String[]{"prefix", "iotdb"});
        TreePattern treePattern = TreePattern.parsePipePatternFromSourceParameters((PipeParameters)validator.getParameters());
        TablePattern tablePattern = TablePattern.parsePipePatternFromSourceParameters((PipeParameters)validator.getParameters());
        this.validatePattern(treePattern, tablePattern);
        validator.validateAttributeValueRange("extractor.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("extractor.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.history.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validateAttributeValueRange("source.realtime.enable", true, new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).validate(args -> (Boolean)args[0] != false || (Boolean)args[1] != false, "Should not set both history.enable and realtime.enable to false.", new Object[]{validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.history.enable", "source.history.enable"), true), validator.getParameters().getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)});
        this.checkInvalidParameters(validator);
        this.constructHistoricalExtractor();
        this.constructRealtimeExtractor(validator.getParameters());
        this.historicalExtractor.validate(validator);
        this.realtimeExtractor.validate(validator);
    }

    private void validatePattern(TreePattern treePattern, TablePattern tablePattern) {
        if (!treePattern.isLegal()) {
            throw new IllegalArgumentException(String.format("Pattern \"%s\" is illegal.", treePattern));
        }
        if (this.shouldExtractDeletion && (!(treePattern instanceof IoTDBTreePattern) || !((IoTDBTreePattern)treePattern).isPrefix() && !((IoTDBTreePattern)treePattern).isFullPath())) {
            throw new IllegalArgumentException(String.format("The path pattern %s is not valid for the source. Only prefix or full path is allowed.", treePattern));
        }
        if (this.shouldExtractDeletion && tablePattern.hasUserSpecifiedDatabasePatternOrTablePattern()) {
            throw new IllegalArgumentException(String.format("The table model pattern %s can not be specified when deletion capture is enabled.", tablePattern));
        }
    }

    private void checkInvalidParameters(PipeParameterValidator validator) {
        PipeParameters parameters = validator.getParameters();
        if (parameters.hasAnyAttributes(new String[]{"source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time"}) && parameters.hasAnyAttributes(new String[]{"extractor.history.enable", "extractor.realtime.enable", "source.history.enable", "source.realtime.enable"})) {
            LOGGER.warn("When {}, {}, {} or {} is specified, specifying {}, {}, {} and {} is invalid.", new Object[]{"source.start-time", "extractor.start-time", "source.end-time", "extractor.end-time", "source.history.start-time", "extractor.history.start-time", "source.history.end-time", "extractor.history.end-time"});
        }
        validator.validateSynonymAttributes(Arrays.asList("extractor.database-name", "source.database-name"), Arrays.asList("extractor.database", "source.database"), false);
        validator.validateSynonymAttributes(Arrays.asList("extractor.table-name", "source.table-name"), Arrays.asList("extractor.table", "source.table"), false);
        validator.validateSynonymAttributes(Arrays.asList("extractor.mode.snapshot", "source.mode.snapshot"), Arrays.asList("extractor.mode", "source.mode"), false);
        validator.validateSynonymAttributes(Arrays.asList("extractor.mode.streaming", "source.mode.streaming"), Arrays.asList("extractor.realtime.mode", "source.realtime.mode"), false);
        validator.validateSynonymAttributes(Arrays.asList("extractor.mode.strict", "source.mode.strict"), Arrays.asList("extractor.history.loose-range", "source.history.loose-range", "extractor.realtime.loose-range", "source.realtime.loose-range"), false);
        validator.validateSynonymAttributes(Arrays.asList("extractor.mods.enable", "source.mods.enable"), Arrays.asList("extractor.mods", "source.mods"), false);
        validator.validateSynonymAttributes(Arrays.asList("extractor.watermark.interval-ms", "source.watermark.interval-ms"), Arrays.asList("extractor.watermark-interval-ms", "source.watermark-interval-ms"), false);
        if (!parameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) {
            if (parameters.hasAnyAttributes(new String[]{"extractor.mode.snapshot", "source.mode.snapshot"})) {
                LOGGER.warn("When '{}' ('{}') is set to false, specifying {} and {} is invalid.", new Object[]{"extractor.realtime.enable", "source.realtime.enable", "extractor.mode.snapshot", "source.mode.snapshot"});
            }
            if (parameters.hasAnyAttributes(new String[]{"extractor.mode.streaming", "source.mode.streaming"})) {
                LOGGER.warn("When '{}' ('{}') is set to false, specifying {} and {} is invalid.", new Object[]{"extractor.realtime.enable", "source.realtime.enable", "extractor.mode.streaming", "source.mode.streaming"});
            }
        }
    }

    private void constructHistoricalExtractor() {
        this.historicalExtractor = new PipeHistoricalDataRegionTsFileAndDeletionSource();
    }

    private void constructRealtimeExtractor(PipeParameters parameters) {
        boolean isSnapshotMode;
        if (!parameters.getBooleanOrDefault(Arrays.asList("extractor.realtime.enable", "source.realtime.enable"), true)) {
            this.realtimeExtractor = new PipeRealtimeDataRegionHeartbeatSource();
            LOGGER.info("Pipe: '{}' ('{}') is set to false, use heartbeat realtime extractor.", (Object)"extractor.realtime.enable", (Object)"source.realtime.enable");
            return;
        }
        if (parameters.hasAnyAttributes(new String[]{"extractor.mode.snapshot", "source.mode.snapshot"})) {
            isSnapshotMode = parameters.getBooleanOrDefault(Arrays.asList("extractor.mode.snapshot", "source.mode.snapshot"), false);
        } else {
            String extractorModeValue = parameters.getStringOrDefault(Arrays.asList("extractor.mode", "source.mode"), "live");
            boolean bl = isSnapshotMode = extractorModeValue.equalsIgnoreCase("snapshot") || extractorModeValue.equalsIgnoreCase("query");
        }
        if (isSnapshotMode) {
            this.realtimeExtractor = new PipeRealtimeDataRegionHeartbeatSource();
            LOGGER.info("Pipe: snapshot mode is enabled, use heartbeat realtime extractor.");
            return;
        }
        if (this.pipeName == null || !this.pipeName.startsWith("__subscription.") && !this.pipeName.startsWith("__consensus.")) {
            this.realtimeExtractor = new PipeRealtimeDataRegionTsFileSource();
            return;
        }
        if (!parameters.hasAnyAttributes(new String[]{"extractor.mode.streaming", "source.mode.streaming"}) && !parameters.hasAnyAttributes(new String[]{"extractor.realtime.mode", "source.realtime.mode"})) {
            this.realtimeExtractor = new PipeRealtimeDataRegionHybridSource();
            LOGGER.info("Pipe: '{}' ('{}') and '{}' ('{}') is not set, use hybrid mode by default.", new Object[]{"extractor.mode.streaming", "source.mode.streaming", "extractor.realtime.mode", "source.realtime.mode"});
            return;
        }
        if (parameters.hasAnyAttributes(new String[]{"extractor.mode.streaming", "source.mode.streaming"})) {
            boolean isStreamingMode = parameters.getBooleanOrDefault(Arrays.asList("extractor.mode.streaming", "source.mode.streaming"), true);
            this.realtimeExtractor = isStreamingMode ? new PipeRealtimeDataRegionHybridSource() : new PipeRealtimeDataRegionTsFileSource();
            return;
        }
        switch (parameters.getStringByKeys(new String[]{"extractor.realtime.mode", "source.realtime.mode"})) {
            case "file": 
            case "batch": {
                this.realtimeExtractor = new PipeRealtimeDataRegionTsFileSource();
                break;
            }
            case "hybrid": 
            case "log": 
            case "stream": {
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridSource();
                break;
            }
            case "forced-log": {
                this.realtimeExtractor = new PipeRealtimeDataRegionLogSource();
                break;
            }
            default: {
                this.realtimeExtractor = new PipeRealtimeDataRegionHybridSource();
                if (!LOGGER.isWarnEnabled()) break;
                LOGGER.warn("Pipe: Unsupported extractor realtime mode: {}, create a hybrid extractor.", (Object)parameters.getStringByKeys(new String[]{"extractor.realtime.mode", "source.realtime.mode"}));
            }
        }
    }

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        if (this.hasNoExtractionNeed) {
            return;
        }
        super.customize(parameters, configuration);
        this.historicalExtractor.customize(parameters, configuration);
        this.realtimeExtractor.customize(parameters, configuration);
        long watermarkIntervalInMs = -1L;
        if (parameters.hasAnyAttributes(new String[]{"extractor.watermark.interval-ms", "source.watermark.interval-ms"})) {
            watermarkIntervalInMs = parameters.getLongOrDefault(Arrays.asList("extractor.watermark-interval-ms", "source.watermark-interval-ms"), -1L);
        } else if (parameters.hasAnyAttributes(new String[]{"extractor.watermark-interval-ms", "source.watermark-interval-ms"})) {
            watermarkIntervalInMs = parameters.getLongOrDefault(Arrays.asList("extractor.watermark-interval-ms", "source.watermark-interval-ms"), -1L);
        }
        if (watermarkIntervalInMs > 0L) {
            this.watermarkInjector = new DataRegionWatermarkInjector(this.regionId, watermarkIntervalInMs);
            LOGGER.info("Pipe {}@{}: Set watermark injector with interval {} ms.", new Object[]{this.pipeName, this.regionId, this.watermarkInjector.getInjectionIntervalInMs()});
        }
        PipeDataRegionSourceMetrics.getInstance().register(this);
        PipeTsFileToTabletsMetrics.getInstance().register(this);
        PipeDataNodeSinglePipeMetrics.getInstance().register(this);
    }

    public void start() throws Exception {
        if (this.hasNoExtractionNeed || this.hasBeenStarted.get()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info("Pipe {}@{}: Starting historical extractor {} and realtime extractor {}.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName()});
        super.start();
        AtomicReference<Object> exceptionHolder = new AtomicReference<Object>(null);
        DataRegionId dataRegionIdObject = new DataRegionId(this.regionId);
        while (true) {
            if (StorageEngine.getInstance().runIfPresent(dataRegionIdObject, dataRegion -> {
                dataRegion.writeLock(String.format("Pipe: starting %s", IoTDBDataRegionSource.class.getName()));
                try {
                    this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder);
                }
                finally {
                    dataRegion.writeUnlock();
                }
            }) || StorageEngine.getInstance().runIfAbsent(dataRegionIdObject, () -> this.startHistoricalExtractorAndRealtimeExtractor(exceptionHolder))) {
                this.rethrowExceptionIfAny(exceptionHolder);
                LOGGER.info("Pipe {}@{}: Started historical extractor {} and realtime extractor {} successfully within {} ms.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName(), System.currentTimeMillis() - startTime});
                return;
            }
            this.rethrowExceptionIfAny(exceptionHolder);
        }
    }

    private void startHistoricalExtractorAndRealtimeExtractor(AtomicReference<Exception> exceptionHolder) {
        try {
            this.realtimeExtractor.start();
            this.historicalExtractor.start();
        }
        catch (Exception e) {
            exceptionHolder.set(e);
            LOGGER.warn("Pipe {}@{}: Start historical extractor {} and realtime extractor {} error.", new Object[]{this.pipeName, this.regionId, this.historicalExtractor.getClass().getSimpleName(), this.realtimeExtractor.getClass().getSimpleName(), e});
        }
    }

    private void rethrowExceptionIfAny(AtomicReference<Exception> exceptionHolder) {
        if (exceptionHolder.get() != null) {
            throw new PipeException("failed to start extractors.", (Throwable)exceptionHolder.get());
        }
    }

    public Event supply() throws Exception {
        if (this.hasNoExtractionNeed) {
            return null;
        }
        Event event = null;
        if (!this.historicalExtractor.hasConsumedAll()) {
            event = this.historicalExtractor.supply();
        } else {
            if (Objects.nonNull(this.watermarkInjector)) {
                event = this.watermarkInjector.inject();
            }
            if (Objects.isNull(event)) {
                event = this.realtimeExtractor.supply();
            }
        }
        if (Objects.nonNull(event)) {
            if (event instanceof TabletInsertionEvent) {
                PipeDataRegionSourceMetrics.getInstance().markTabletEvent(this.taskID);
            } else if (event instanceof TsFileInsertionEvent) {
                PipeDataRegionSourceMetrics.getInstance().markTsFileEvent(this.taskID);
            } else if (event instanceof PipeHeartbeatEvent) {
                PipeDataRegionSourceMetrics.getInstance().markPipeHeartbeatEvent(this.taskID);
            }
        }
        return event;
    }

    public void close() throws Exception {
        if (this.hasNoExtractionNeed || !this.hasBeenStarted.get()) {
            return;
        }
        this.historicalExtractor.close();
        this.realtimeExtractor.close();
        if (Objects.nonNull(this.taskID)) {
            PipeDataRegionSourceMetrics.getInstance().deregister(this.taskID);
        }
    }

    public int getHistoricalTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() && Objects.nonNull(this.historicalExtractor) ? this.historicalExtractor.getPendingQueueSize() : 0;
    }

    public int getTabletInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTabletInsertionEventCount() : 0;
    }

    public int getRealtimeTsFileInsertionEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getTsFileInsertionEventCount() : 0;
    }

    public int getPipeHeartbeatEventCount() {
        return this.hasBeenStarted.get() ? this.realtimeExtractor.getPipeHeartbeatEventCount() : 0;
    }
}

