/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.writer;

import java.io.File;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.writer.TsFileIOWriter;

public class TsFileIOWriterEndFileTest {
    public static void main(String[] args) throws Exception {
        try (TsFileIOWriter writer = new TsFileIOWriter(new File("test.tsfile"));){
            for (int deviceIndex = 0; deviceIndex < 1000; ++deviceIndex) {
                writer.startChunkGroup(IDeviceID.Factory.DEFAULT_FACTORY.create("root.sg.d" + deviceIndex));
                for (int seriesIndex = 0; seriesIndex < 1000; ++seriesIndex) {
                    ChunkWriterImpl chunkWriter = new ChunkWriterImpl(new MeasurementSchema("s" + seriesIndex, TSDataType.INT32, TSEncoding.RLE, CompressionType.GZIP));
                    for (long time = 0L; time < 10L; ++time) {
                        chunkWriter.write(time, 0);
                    }
                    chunkWriter.writeToFileWriter(writer);
                }
                writer.endChunkGroup();
            }
            writer.endFile();
        }
    }
}

