/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.protocol;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.MemoizedSupplier;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.ProtoUtils;

public interface RoutingTable {
    public Set<RaftPeerId> getSuccessors(RaftPeerId var1);

    public RaftPeerId getPrimary();

    public RaftProtos.RoutingTableProto toProto();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static RoutingTable newRoutingTable(final Map<RaftPeerId, Set<RaftPeerId>> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        final RaftPeerId primary = Builder.validate(map);
        final MemoizedSupplier<RaftProtos.RoutingTableProto> proto = JavaUtils.memoize(() -> RaftProtos.RoutingTableProto.newBuilder().addAllRoutes(ProtoUtils.toRouteProtos(map)).build());
        return new RoutingTable(){

            @Override
            public Set<RaftPeerId> getSuccessors(RaftPeerId peerId) {
                return Optional.ofNullable((Set)map.get(peerId)).orElseGet(Collections::emptySet);
            }

            @Override
            public RaftPeerId getPrimary() {
                return primary;
            }

            @Override
            public RaftProtos.RoutingTableProto toProto() {
                return (RaftProtos.RoutingTableProto)proto.get();
            }
        };
    }

    public static final class Builder {
        private final AtomicReference<Map<RaftPeerId, Set<RaftPeerId>>> ref = new AtomicReference(new HashMap());

        private Builder() {
        }

        private Set<RaftPeerId> computeIfAbsent(RaftPeerId peerId) {
            return Optional.ofNullable(this.ref.get()).map(map -> map.computeIfAbsent(peerId, key -> new HashSet())).orElseThrow(() -> new IllegalStateException("Already built"));
        }

        public Builder addSuccessor(RaftPeerId peerId, RaftPeerId successor) {
            this.computeIfAbsent(peerId).add(successor);
            return this;
        }

        public Builder addSuccessors(RaftPeerId peerId, Collection<RaftPeerId> successors) {
            this.computeIfAbsent(peerId).addAll(successors);
            return this;
        }

        public Builder addSuccessors(RaftPeerId peerId, RaftPeerId ... successors) {
            return this.addSuccessors(peerId, Arrays.asList(successors));
        }

        public RoutingTable build() {
            Map map = this.ref.getAndSet(null);
            if (map == null) {
                throw new IllegalStateException("RoutingTable is already built.");
            }
            return RoutingTable.newRoutingTable(map);
        }

        static RaftPeerId validate(Map<RaftPeerId, Set<RaftPeerId>> map) {
            return new Validation(map).run();
        }

        private static final class Validation {
            private final Map<RaftPeerId, Set<RaftPeerId>> map;
            private final RaftPeerId primary;
            private final Set<RaftPeerId> unreachablePeers;

            private Validation(Map<RaftPeerId, Set<RaftPeerId>> map) {
                this.map = Objects.requireNonNull(map, "map == null");
                HashSet<RaftPeerId> allPeers = new HashSet<RaftPeerId>(map.keySet());
                HashSet<RaftPeerId> startingPeers = new HashSet<RaftPeerId>(map.keySet());
                int numEdges = 0;
                for (Map.Entry<RaftPeerId, Set<RaftPeerId>> entry : map.entrySet()) {
                    Set<RaftPeerId> successors = entry.getValue();
                    if (successors == null) continue;
                    for (RaftPeerId s : successors) {
                        Preconditions.assertTrue(!s.equals(entry.getKey()), () -> "Invalid routing table: the peer " + s + " has a self-loop, " + this);
                        if (startingPeers.remove(s)) continue;
                        boolean added = allPeers.add(s);
                        Preconditions.assertTrue(added, () -> "Invalid routing table: the peer " + s + " has more than one predecessors, " + this);
                    }
                    numEdges += successors.size();
                }
                Preconditions.assertTrue(numEdges == allPeers.size() - 1, "Invalid routing table: #edges = %d != #vertices - 1, #vertices=%d, %s", numEdges, allPeers.size(), this);
                Preconditions.assertTrue(!startingPeers.isEmpty(), () -> "Invalid routing table: Starting peer not found, " + this);
                Preconditions.assertTrue(startingPeers.size() == 1, () -> "Invalid routing table: More than one starting peers: " + startingPeers + ", " + this);
                this.primary = (RaftPeerId)startingPeers.iterator().next();
                this.unreachablePeers = allPeers;
            }

            private RaftPeerId run() {
                this.depthFirstSearch(this.primary);
                Preconditions.assertTrue(this.unreachablePeers.isEmpty(), () -> "Invalid routing table: peer(s) " + this.unreachablePeers + " are unreachable, " + this);
                return this.primary;
            }

            private void depthFirstSearch(RaftPeerId current) {
                boolean removed = this.unreachablePeers.remove(current);
                Preconditions.assertTrue(removed, () -> "Invalid routing table: the peer " + current + " has more than one predecessors, " + this);
                for (RaftPeerId successor : this.get(current)) {
                    this.depthFirstSearch(successor);
                }
            }

            private Set<RaftPeerId> get(RaftPeerId peerId) {
                return Optional.ofNullable(this.map.get(peerId)).orElseGet(Collections::emptySet);
            }

            public String toString() {
                return "primary=" + this.primary + ", map=" + this.map;
            }
        }
    }
}

