/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.memory.MemoryBlockType;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.listener.PipeTimePartitionListener;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.rescon.memory.TimePartitionInfo;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePartitionManager {
    private static final Logger logger = LoggerFactory.getLogger(TimePartitionManager.class);
    final Map<DataRegionId, Map<Long, TimePartitionInfo>> timePartitionInfoMap = new HashMap<DataRegionId, Map<Long, TimePartitionInfo>>();
    IMemoryBlock timePartitionInfoMemoryBlock = IoTDBDescriptor.getInstance().getMemoryConfig().getTimePartitionInfoMemoryManager().exactAllocate("TimePartitionInfoMemoryBlock", MemoryBlockType.DYNAMIC);

    private TimePartitionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTimePartitionInfo(TimePartitionInfo timePartitionInfo) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            TreeMap timePartitionInfoMapForRegion = (TreeMap)this.timePartitionInfoMap.computeIfAbsent(timePartitionInfo.dataRegionId, k -> new TreeMap());
            timePartitionInfoMapForRegion.put(timePartitionInfo.partitionId, timePartitionInfo);
            PipeTimePartitionListener.getInstance().listenToTimePartitionGrow(String.valueOf(timePartitionInfo.dataRegionId.getId()), (Pair<Long, Long>)new Pair((Object)((Long)timePartitionInfoMapForRegion.firstKey()), (Object)((Long)timePartitionInfoMapForRegion.lastKey())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAfterFlushing(DataRegionId dataRegionId, long timePartitionId, long systemFlushTime, long memSize, boolean isActive) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            TimePartitionInfo timePartitionInfo = (TimePartitionInfo)this.timePartitionInfoMap.computeIfAbsent(dataRegionId, k -> new TreeMap()).get(timePartitionId);
            if (timePartitionInfo != null) {
                timePartitionInfo.lastSystemFlushTime = systemFlushTime;
                this.timePartitionInfoMemoryBlock.forceAllocateWithoutLimitation(memSize - timePartitionInfo.memSize);
                timePartitionInfo.memSize = memSize;
                timePartitionInfo.isActive = isActive;
                if (this.timePartitionInfoMemoryBlock.getUsedMemoryInBytes() > this.timePartitionInfoMemoryBlock.getTotalMemorySizeInBytes()) {
                    this.degradeLastFlushTime();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAfterOpeningTsFileProcessor(DataRegionId dataRegionId, long timePartitionId) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            TimePartitionInfo timePartitionInfo = (TimePartitionInfo)this.timePartitionInfoMap.computeIfAbsent(dataRegionId, k -> new TreeMap()).get(timePartitionId);
            if (timePartitionInfo != null) {
                timePartitionInfo.isActive = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void degradeLastFlushTime() {
        TreeSet<TimePartitionInfo> treeSet = new TreeSet<TimePartitionInfo>(TimePartitionInfo::comparePriority);
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            for (Map.Entry<DataRegionId, Map<Long, TimePartitionInfo>> entry : this.timePartitionInfoMap.entrySet()) {
                treeSet.addAll(entry.getValue().values());
            }
            while (this.timePartitionInfoMemoryBlock.getUsedMemoryInBytes() > this.timePartitionInfoMemoryBlock.getTotalMemorySizeInBytes()) {
                TimePartitionInfo timePartitionInfo = (TimePartitionInfo)treeSet.pollFirst();
                if (timePartitionInfo == null) {
                    return;
                }
                this.timePartitionInfoMemoryBlock.release(timePartitionInfo.memSize);
                DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(timePartitionInfo.dataRegionId);
                if (dataRegion != null) {
                    dataRegion.degradeFlushTimeMap(timePartitionInfo.partitionId);
                    logger.info("[{}]degrade LastFlushTimeMap of old TimePartitionInfo-{}, mem size is {}, remaining mem cost is {}", new Object[]{timePartitionInfo.dataRegionId, timePartitionInfo.partitionId, timePartitionInfo.memSize, this.timePartitionInfoMemoryBlock.getUsedMemoryInBytes()});
                }
                this.timePartitionInfoMap.get(timePartitionInfo.dataRegionId).remove(timePartitionInfo.partitionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimePartitionInfo(DataRegionId dataRegionId) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            Map<Long, TimePartitionInfo> timePartitionInfoMapForRegion = this.timePartitionInfoMap.remove(dataRegionId);
            if (timePartitionInfoMapForRegion != null) {
                for (TimePartitionInfo timePartitionInfo : timePartitionInfoMapForRegion.values()) {
                    if (timePartitionInfo == null) continue;
                    this.timePartitionInfoMemoryBlock.release(timePartitionInfo.memSize);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public TimePartitionInfo getTimePartitionInfo(DataRegionId dataRegionId, long timePartitionId) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            Map<Long, TimePartitionInfo> timePartitionInfoMapForDataRegion = this.timePartitionInfoMap.get(dataRegionId);
            if (timePartitionInfoMapForDataRegion == null) {
                return null;
            }
            return timePartitionInfoMapForDataRegion.get(timePartitionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void clear() {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            this.timePartitionInfoMap.clear();
            this.timePartitionInfoMemoryBlock.setUsedMemoryInBytes(0L);
        }
    }

    @TestOnly
    public void setTimePartitionInfoMemoryThreshold(long timePartitionInfoMemoryThreshold) {
        this.timePartitionInfoMemoryBlock.setTotalMemorySizeInBytes(timePartitionInfoMemoryThreshold);
    }

    public static TimePartitionManager getInstance() {
        return InstanceHolder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Long, Long> getTimePartitionIdBound(DataRegionId dataRegionId) {
        Map<DataRegionId, Map<Long, TimePartitionInfo>> map = this.timePartitionInfoMap;
        synchronized (map) {
            Map<Long, TimePartitionInfo> timePartitionInfoMapForDataRegion = this.timePartitionInfoMap.get(dataRegionId);
            if (Objects.nonNull(timePartitionInfoMapForDataRegion) && !timePartitionInfoMapForDataRegion.isEmpty() && timePartitionInfoMapForDataRegion instanceof TreeMap) {
                return new Pair((Object)((Long)((TreeMap)timePartitionInfoMapForDataRegion).firstKey()), (Object)((Long)((TreeMap)timePartitionInfoMapForDataRegion).lastKey()));
            }
        }
        return null;
    }

    private static class InstanceHolder {
        private static TimePartitionManager instance = new TimePartitionManager();

        private InstanceHolder() {
        }
    }
}

