/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.metadata.PageMetadata;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.BatchDataFactory;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.series.PaginationController;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class MemPageReader
implements IPageReader {
    private TsBlock tsBlock;
    private Filter recordFilter;
    private final int pageIndex;
    private final Supplier<TsBlock> tsBlockSupplier;
    private final TSDataType tsDataType;
    private final PageMetadata pageMetadata;
    private PaginationController paginationController = PaginationController.UNLIMITED_PAGINATION_CONTROLLER;

    public MemPageReader(Supplier<TsBlock> tsBlockSupplier, int pageIndex, TSDataType tsDataType, String measurementUid, Statistics statistics, Filter recordFilter) {
        this.tsBlockSupplier = tsBlockSupplier;
        this.pageIndex = pageIndex;
        this.recordFilter = recordFilter;
        this.tsDataType = tsDataType;
        this.pageMetadata = new PageMetadata(measurementUid, tsDataType, (Statistics<? extends Serializable>)statistics);
    }

    public BatchData getAllSatisfiedPageData(boolean ascending) throws IOException {
        this.getTsBlock();
        BatchData batchData = BatchDataFactory.createBatchData((TSDataType)this.tsDataType, (boolean)ascending, (boolean)false);
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        block8: for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
            if (!satisfyInfo[i]) continue;
            switch (this.tsDataType) {
                case BOOLEAN: {
                    batchData.putBoolean(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getBoolean(i));
                    continue block8;
                }
                case INT32: 
                case DATE: {
                    batchData.putInt(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getInt(i));
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    batchData.putLong(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getLong(i));
                    continue block8;
                }
                case DOUBLE: {
                    batchData.putDouble(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getDouble(i));
                    continue block8;
                }
                case FLOAT: {
                    batchData.putFloat(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getFloat(i));
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    batchData.putBinary(this.tsBlock.getTimeColumn().getLong(i), this.tsBlock.getColumn(0).getBinary(i));
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.valueOf(this.tsDataType));
                }
            }
        }
        return batchData.flip();
    }

    public TsBlock getAllSatisfiedData() {
        this.getTsBlock();
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(this.tsDataType));
        boolean[] satisfyInfo = this.buildSatisfyInfoArray();
        int readEndIndex = this.buildTimeColumn(builder, satisfyInfo);
        this.buildValueColumn(builder, satisfyInfo, readEndIndex);
        return builder.build();
    }

    private boolean[] buildSatisfyInfoArray() {
        if (this.recordFilter == null || this.recordFilter.allSatisfy((IMetadata)this)) {
            boolean[] satisfyInfo = new boolean[this.tsBlock.getPositionCount()];
            Arrays.fill(satisfyInfo, true);
            return satisfyInfo;
        }
        return this.recordFilter.satisfyTsBlock(this.tsBlock);
    }

    private int buildTimeColumn(TsBlockBuilder builder, boolean[] satisfyInfo) {
        int readEndIndex = this.tsBlock.getPositionCount();
        for (int rowIndex = 0; rowIndex < readEndIndex; ++rowIndex) {
            if (this.needSkipCurrentRow(satisfyInfo, rowIndex)) continue;
            if (this.paginationController.hasCurLimit()) {
                builder.getTimeColumnBuilder().writeLong(this.tsBlock.getTimeByIndex(rowIndex));
                builder.declarePosition();
                this.paginationController.consumeLimit();
                continue;
            }
            readEndIndex = rowIndex;
        }
        return readEndIndex;
    }

    private boolean needSkipCurrentRow(boolean[] satisfyInfo, int rowIndex) {
        if (!satisfyInfo[rowIndex]) {
            return true;
        }
        if (this.paginationController.hasCurOffset()) {
            this.paginationController.consumeOffset();
            satisfyInfo[rowIndex] = false;
            return true;
        }
        return false;
    }

    private void buildValueColumn(TsBlockBuilder builder, boolean[] satisfyInfo, int readEndIndex) {
        for (int column = 0; column < this.tsBlock.getValueColumnCount(); ++column) {
            Column valueColumn = this.tsBlock.getColumn(column);
            ColumnBuilder valueBuilder = builder.getColumnBuilder(column);
            for (int row = 0; row < readEndIndex; ++row) {
                if (!satisfyInfo[row]) continue;
                if (!valueColumn.isNull(row)) {
                    valueBuilder.write(valueColumn, row);
                    continue;
                }
                valueBuilder.appendNull();
            }
        }
    }

    public Statistics<? extends Serializable> getStatistics() {
        return this.pageMetadata.getStatistics();
    }

    public Statistics<? extends Serializable> getTimeStatistics() {
        return this.pageMetadata.getTimeStatistics();
    }

    public Optional<Statistics<? extends Serializable>> getMeasurementStatistics(int measurementIndex) {
        return this.pageMetadata.getMeasurementStatistics(measurementIndex);
    }

    public boolean hasNullValue(int measurementIndex) {
        return this.pageMetadata.hasNullValue(measurementIndex);
    }

    public void addRecordFilter(Filter filter) {
        this.recordFilter = FilterFactory.and((Filter)this.recordFilter, (Filter)filter);
    }

    public void setLimitOffset(PaginationController paginationController) {
        this.paginationController = paginationController;
    }

    public boolean isModified() {
        return false;
    }

    public void initTsBlockBuilder(List<TSDataType> dataTypes) {
    }

    private void getTsBlock() {
        if (this.tsBlock == null) {
            this.initializeTsBlockIndex();
            this.tsBlock = this.tsBlockSupplier.get();
            if (this.pageMetadata.getStatistics() == null) {
                this.initPageStatistics();
            }
        }
    }

    private void initializeTsBlockIndex() {
        if (this.tsBlockSupplier instanceof MemChunkReader.TsBlockSupplier) {
            ((MemChunkReader.TsBlockSupplier)this.tsBlockSupplier).setTsBlockIndex(this.pageIndex);
        }
    }

    private void initPageStatistics() {
        Statistics statistics = Statistics.getStatsByType((TSDataType)this.tsDataType);
        this.updatePageStatisticsFromTsBlock(statistics);
        statistics.setEmpty(this.tsBlock.isEmpty());
        this.pageMetadata.setStatistics((Statistics<? extends Serializable>)statistics);
    }

    private void updatePageStatisticsFromTsBlock(Statistics statistics) {
        if (!this.tsBlock.isEmpty()) {
            switch (this.tsDataType) {
                case BOOLEAN: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statistics.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getBoolean(i));
                    }
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statistics.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getBinary(i));
                    }
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statistics.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getFloat(i));
                    }
                    break;
                }
                case INT32: 
                case DATE: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statistics.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getInt(i));
                    }
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statistics.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getLong(i));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < this.tsBlock.getPositionCount(); ++i) {
                        statistics.update(this.tsBlock.getTimeByIndex(i), this.tsBlock.getColumn(0).getDouble(i));
                    }
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", this.tsDataType));
                }
            }
        }
    }
}

