/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.schedule;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TTLScheduleTask
implements Callable<Void> {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private final List<DataRegion> dataRegionList;
    private final int workerId;
    private final int workerNum;
    private final long ttlCheckInterval = CommonDescriptor.getInstance().getConfig().getTTLCheckInterval();

    public TTLScheduleTask(List<DataRegion> dataRegionList, int workerId, int workerNum) {
        this.dataRegionList = dataRegionList;
        this.workerId = workerId;
        this.workerNum = workerNum;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Void call() throws Exception {
        try {
            block2: while (true) {
                Thread.sleep(this.ttlCheckInterval);
                if (!StorageEngine.getInstance().isReadyForNonReadWriteFunctions()) continue;
                dataRegionListSnapshot = new ArrayList<DataRegion>(this.dataRegionList);
                i = 0;
                while (true) {
                    if (i < dataRegionListSnapshot.size()) ** break;
                    continue block2;
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (i % this.workerNum == this.workerId) {
                        ((DataRegion)dataRegionListSnapshot.get(i)).executeTTLCheck();
                    }
                    ++i;
                }
                break;
            }
        }
        catch (InterruptedException ignored) {
            TTLScheduleTask.logger.info("[TTLCheckTask-{}] TTL checker is interrupted", (Object)this.workerId);
            return null;
        }
    }
}

