/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.ternary;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public abstract class TernaryColumnTransformer
extends ColumnTransformer {
    protected ColumnTransformer firstColumnTransformer;
    protected ColumnTransformer secondColumnTransformer;
    protected ColumnTransformer thirdColumnTransformer;

    protected TernaryColumnTransformer(Type returnType, ColumnTransformer firstColumnTransformer, ColumnTransformer secondColumnTransformer, ColumnTransformer thirdColumnTransformer) {
        super(returnType);
        this.firstColumnTransformer = firstColumnTransformer;
        this.secondColumnTransformer = secondColumnTransformer;
        this.thirdColumnTransformer = thirdColumnTransformer;
        this.checkType();
    }

    @Override
    protected void evaluate() {
        this.firstColumnTransformer.tryEvaluate();
        this.secondColumnTransformer.tryEvaluate();
        this.thirdColumnTransformer.tryEvaluate();
        int positionCount = this.firstColumnTransformer.getColumnCachePositionCount();
        Column firstColumn = this.firstColumnTransformer.getColumn();
        Column secondColumn = this.secondColumnTransformer.getColumn();
        Column thirdColumn = this.thirdColumnTransformer.getColumn();
        ColumnBuilder columnBuilder = this.returnType.createColumnBuilder(positionCount);
        this.doTransform(firstColumn, secondColumn, thirdColumn, columnBuilder, positionCount);
        this.initializeColumnCache(columnBuilder.build());
    }

    @Override
    public void evaluateWithSelection(boolean[] selection) {
        this.firstColumnTransformer.evaluateWithSelection(selection);
        this.secondColumnTransformer.evaluateWithSelection(selection);
        this.thirdColumnTransformer.evaluateWithSelection(selection);
        int positionCount = this.firstColumnTransformer.getColumnCachePositionCount();
        Column firstColumn = this.firstColumnTransformer.getColumn();
        Column secondColumn = this.secondColumnTransformer.getColumn();
        Column thirdColumn = this.thirdColumnTransformer.getColumn();
        ColumnBuilder columnBuilder = this.returnType.createColumnBuilder(positionCount);
        this.doTransform(firstColumn, secondColumn, thirdColumn, columnBuilder, positionCount, selection);
        this.initializeColumnCache(columnBuilder.build());
        this.firstColumnTransformer.clearCache();
        this.secondColumnTransformer.clearCache();
        this.thirdColumnTransformer.clearCache();
    }

    protected abstract void doTransform(Column var1, Column var2, Column var3, ColumnBuilder var4, int var5);

    protected abstract void doTransform(Column var1, Column var2, Column var3, ColumnBuilder var4, int var5, boolean[] var6);

    public ColumnTransformer getFirstColumnTransformer() {
        return this.firstColumnTransformer;
    }

    public ColumnTransformer getSecondColumnTransformer() {
        return this.secondColumnTransformer;
    }

    public ColumnTransformer getThirdColumnTransformer() {
        return this.thirdColumnTransformer;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.firstColumnTransformer.clearCache();
        this.secondColumnTransformer.clearCache();
        this.thirdColumnTransformer.clearCache();
    }
}

