/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;

public class ExplainAnalyzeNode
extends SingleChildProcessNode {
    private final boolean verbose;
    private final long queryId;
    private final long timeout;
    private final Symbol outputSymbol;
    private final List<Symbol> childPermittedOutputs;

    public ExplainAnalyzeNode(PlanNodeId id, PlanNode child, boolean verbose, long queryId, long timeout, Symbol outputSymbol, List<Symbol> childPermittedOutputs) {
        super(id, child);
        this.verbose = verbose;
        this.timeout = timeout;
        this.queryId = queryId;
        this.outputSymbol = outputSymbol;
        this.childPermittedOutputs = childPermittedOutputs;
    }

    @Override
    public PlanNode clone() {
        return new ExplainAnalyzeNode(this.getPlanNodeId(), this.child, this.verbose, this.queryId, this.timeout, this.outputSymbol, this.childPermittedOutputs);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitExplainAnalyze(this, context);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return null;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return Collections.singletonList(this.outputSymbol);
    }

    public List<Symbol> getChildPermittedOutputs() {
        return this.childPermittedOutputs;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ExplainAnalyzeNode(this.getPlanNodeId(), newChildren.get(0), this.verbose, this.queryId, this.timeout, this.outputSymbol, this.childPermittedOutputs);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new UnsupportedOperationException("ExplainAnalyzeNode should not be serialized");
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException("ExplainAnalyzeNode should not be serialized");
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExplainAnalyzeNode)) {
            return false;
        }
        ExplainAnalyzeNode that = (ExplainAnalyzeNode)o;
        return this.verbose == that.verbose && this.queryId == that.queryId && this.timeout == that.timeout;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Boolean.hashCode(this.verbose) + Long.hashCode(this.queryId) + Long.hashCode(this.timeout);
    }
}

