/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.process.rowpattern.matcher.Instruction;

public class Program {
    private final List<Instruction> instructions;
    private final int minSlotCount;
    private final int minLabelCount;

    public Program(List<Instruction> instructions) {
        this.instructions = ImmutableList.copyOf(instructions);
        this.minSlotCount = Math.toIntExact(instructions.stream().filter(instruction -> instruction.type() == Instruction.Type.SAVE).count());
        this.minLabelCount = Math.toIntExact(instructions.stream().filter(instruction -> instruction.type() == Instruction.Type.MATCH_LABEL).count());
    }

    public Instruction at(int pointer) {
        return this.instructions.get(pointer);
    }

    public int size() {
        return this.instructions.size();
    }

    public List<Instruction> getInstructions() {
        return ImmutableList.copyOf(this.instructions);
    }

    public int getMinSlotCount() {
        return this.minSlotCount;
    }

    public int getMinLabelCount() {
        return this.minLabelCount;
    }

    public String dump() {
        StringBuilder builder = new StringBuilder();
        builder.append("Min slots: ").append(this.minSlotCount).append("\n").append("Min labels: ").append(this.minLabelCount).append("\n");
        for (int i = 0; i < this.instructions.size(); ++i) {
            builder.append(String.format("%s: %s\n", i, this.instructions.get(i)));
        }
        return builder.toString();
    }
}

