/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionSourceMetrics;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.epoch.TsFileEpochStateMigrator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class TsFileEpoch {
    private final TsFileResource resource;
    private final ConcurrentMap<PipeRealtimeDataRegionSource, AtomicReference<State>> dataRegionExtractor2State;
    private final AtomicLong insertNodeMinTime;

    public TsFileEpoch(TsFileResource resource) {
        this.resource = resource;
        this.dataRegionExtractor2State = new ConcurrentHashMap<PipeRealtimeDataRegionSource, AtomicReference<State>>();
        this.insertNodeMinTime = new AtomicLong(Long.MAX_VALUE);
    }

    public State getState(PipeRealtimeDataRegionSource extractor) {
        return (State)((Object)this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).get());
    }

    public void migrateState(PipeRealtimeDataRegionSource extractor, TsFileEpochStateMigrator visitor) {
        this.dataRegionExtractor2State.computeIfAbsent(extractor, o -> new AtomicReference<State>(State.EMPTY)).getAndUpdate(visitor::migrate);
    }

    public void setExtractorsRecentProcessedTsFileEpochState() {
        this.dataRegionExtractor2State.forEach((extractor, state) -> PipeDataRegionSourceMetrics.getInstance().setRecentProcessedTsFileEpochState(extractor.getTaskID(), (State)((Object)((Object)state.get()))));
    }

    public void updateInsertNodeMinTime(long newComingMinTime) {
        this.insertNodeMinTime.updateAndGet(recordedMinTime -> Math.min(recordedMinTime, newComingMinTime));
    }

    public TsFileResource getResource() {
        return this.resource;
    }

    public String getFilePath() {
        return this.resource.getTsFilePath();
    }

    public String toString() {
        return "TsFileEpoch{resource='" + this.resource + '\'' + ", dataRegionExtractor2State=" + this.dataRegionExtractor2State + '\'' + ", insertNodeMinTime=" + this.insertNodeMinTime.get() + '}';
    }

    public static enum State {
        EMPTY(0),
        USING_TABLET(1),
        USING_BOTH(2),
        USING_TSFILE(3);

        private final int id;

        private State(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

