/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.util.sorter;

import java.time.LocalDate;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class PipeTabletEventSorter {
    protected final Tablet tablet;
    protected Integer[] index;
    protected boolean isSorted = true;
    protected boolean isDeDuplicated = true;
    protected int[] deDuplicatedIndex;
    protected int deDuplicatedSize;

    public PipeTabletEventSorter(Tablet tablet) {
        this.tablet = tablet;
    }

    protected void sortAndMayDeduplicateValuesAndBitMaps() {
        int columnIndex = 0;
        int size = this.tablet.getSchemas().size();
        for (int i = 0; i < size; ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)this.tablet.getSchemas().get(i);
            if (schema == null) continue;
            BitMap deDuplicatedBitMap = null;
            BitMap originalBitMap = null;
            if (this.tablet.getBitMaps() != null && this.tablet.getBitMaps()[columnIndex] != null) {
                originalBitMap = this.tablet.getBitMaps()[columnIndex];
                deDuplicatedBitMap = new BitMap(originalBitMap.getSize());
            }
            this.tablet.getValues()[columnIndex] = this.reorderValueListAndBitMap(this.tablet.getValues()[columnIndex], schema.getType(), originalBitMap, deDuplicatedBitMap);
            if (this.tablet.getBitMaps() != null && this.tablet.getBitMaps()[columnIndex] != null) {
                this.tablet.getBitMaps()[columnIndex] = deDuplicatedBitMap;
            }
            ++columnIndex;
        }
    }

    protected Object reorderValueListAndBitMap(Object valueList, TSDataType dataType, BitMap originalBitMap, BitMap deDuplicatedBitMap) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] deDuplicatedBoolValues = new boolean[boolValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedBoolValues[i] = boolValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedBoolValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] deDuplicatedIntValues = new int[intValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedIntValues[i] = intValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedIntValues;
            }
            case DATE: {
                LocalDate[] dateValues = (LocalDate[])valueList;
                LocalDate[] deDuplicatedDateValues = new LocalDate[dateValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedDateValues[i] = dateValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedDateValues;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] longValues = (long[])valueList;
                long[] deDuplicatedLongValues = new long[longValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedLongValues[i] = longValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] deDuplicatedFloatValues = new float[floatValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedFloatValues[i] = floatValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] deDuplicatedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedDoubleValues[i] = doubleValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedDoubleValues;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] deDuplicatedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < this.deDuplicatedSize; ++i) {
                    deDuplicatedBinaryValues[i] = binaryValues[this.getLastNonnullIndex(i, originalBitMap, deDuplicatedBitMap)];
                }
                return deDuplicatedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
    }

    private int getLastNonnullIndex(int i, BitMap originalBitMap, BitMap deDuplicatedBitMap) {
        int lastIndex;
        if (this.deDuplicatedIndex == null) {
            if (originalBitMap != null && originalBitMap.isMarked(this.index[i].intValue())) {
                deDuplicatedBitMap.mark(i);
            }
            return this.index[i];
        }
        if (originalBitMap == null) {
            return this.index[this.deDuplicatedIndex[i]];
        }
        int lastNonnullIndex = this.deDuplicatedIndex[i];
        int n = lastIndex = i > 0 ? this.deDuplicatedIndex[i - 1] : -1;
        while (originalBitMap.isMarked(this.index[lastNonnullIndex].intValue())) {
            if (--lastNonnullIndex != lastIndex) continue;
            deDuplicatedBitMap.mark(i);
            return this.index[lastNonnullIndex + 1];
        }
        return this.index[lastNonnullIndex];
    }
}

