/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers.rpc;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.CnToCnNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.rpc.ConfigNodeAsyncRequestRPCHandler;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeTSStatusRPCHandler
extends ConfigNodeAsyncRequestRPCHandler<TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeTSStatusRPCHandler.class);

    public ConfigNodeTSStatusRPCHandler(CnToCnNodeRequestType requestType, int requestId, TConfigNodeLocation targetConfigNode, Map<Integer, TConfigNodeLocation> configNodeLocationMap, Map<Integer, TSStatus> responseMap, CountDownLatch countDownLatch) {
        super(requestType, requestId, targetConfigNode, configNodeLocationMap, responseMap, countDownLatch);
    }

    public void onComplete(TSStatus response) {
        this.responseMap.put(this.requestId, response);
        if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.nodeLocationMap.remove(this.requestId);
            LOGGER.info("Successfully {} on ConfigNode: {}", this.requestType, (Object)this.formattedTargetLocation);
        } else {
            LOGGER.error("Failed to {} on ConfigNode: {}, response: {}", new Object[]{this.requestType, this.formattedTargetLocation, response});
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception e) {
        String errorMsg = "Failed to " + this.requestType + " on ConfigNode: " + this.formattedTargetLocation + ", exception: " + e.getMessage();
        LOGGER.error(errorMsg);
        this.responseMap.put(this.requestId, new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)errorMsg)));
        this.countDownLatch.countDown();
    }
}

