/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.block;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.controller.IMetadataQuerier;
import org.apache.tsfile.read.expression.ExpressionTree;
import org.apache.tsfile.read.query.executor.task.DeviceQueryTask;
import org.apache.tsfile.read.query.executor.task.DeviceTaskIterator;
import org.apache.tsfile.read.reader.block.SingleDeviceTsBlockReader;
import org.apache.tsfile.read.reader.block.TsBlockReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceOrderedTsBlockReader
implements TsBlockReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceOrderedTsBlockReader.class);
    private final DeviceTaskIterator taskIterator;
    private final IMetadataQuerier metadataQuerier;
    private final IChunkLoader chunkLoader;
    private final int blockSize;
    private SingleDeviceTsBlockReader currentReader;
    private ExpressionTree timeFilter;
    private ExpressionTree measurementFilter;

    public DeviceOrderedTsBlockReader(DeviceTaskIterator taskIterator, IMetadataQuerier metadataQuerier, IChunkLoader chunkLoader, ExpressionTree timeFilter, ExpressionTree measurementFilter, int blockSize) {
        this.taskIterator = taskIterator;
        this.metadataQuerier = metadataQuerier;
        this.chunkLoader = chunkLoader;
        this.blockSize = blockSize;
        this.timeFilter = timeFilter;
        this.measurementFilter = measurementFilter;
    }

    @Override
    public boolean hasNext() {
        if (this.currentReader != null && this.currentReader.hasNext()) {
            return true;
        }
        while (this.taskIterator.hasNext()) {
            DeviceQueryTask nextTask = this.taskIterator.next();
            try {
                this.currentReader = new SingleDeviceTsBlockReader(nextTask, this.metadataQuerier, this.chunkLoader, this.blockSize, this.timeFilter, this.measurementFilter);
            }
            catch (IOException e) {
                LOGGER.error("Failed to construct reader for {}", (Object)nextTask, (Object)e);
            }
            if (this.currentReader == null || !this.currentReader.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public TsBlock next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentReader.next();
    }

    @Override
    public void close() throws Exception {
        if (this.currentReader != null) {
            this.currentReader.close();
        }
    }
}

