/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tsfile.file.MetaMarker;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.reader.TsFileInput;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ChunkGroupHeader {
    private static final byte MARKER = 0;
    private final IDeviceID deviceID;
    private final int serializedSize;

    public ChunkGroupHeader(IDeviceID deviceID) {
        this.deviceID = deviceID;
        this.serializedSize = this.getSerializedSize(deviceID);
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    private int getSerializedSize(IDeviceID deviceID) {
        int length = deviceID.serializedSize();
        return 1 + ReadWriteForEncodingUtils.varIntSize(length) + length;
    }

    public static ChunkGroupHeader deserializeFrom(InputStream inputStream, boolean markerRead, byte versionNumber) throws IOException {
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 0) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        IDeviceID deviceID = ChunkGroupHeader.deserializeDeviceID(inputStream, versionNumber);
        return new ChunkGroupHeader(deviceID);
    }

    public static ChunkGroupHeader deserializeFrom(TsFileInput input, long offset, boolean markerRead, byte versionNumber) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        input.position(offsetVar);
        InputStream inputStream = input.wrapAsInputStream();
        IDeviceID deviceID = ChunkGroupHeader.deserializeDeviceID(inputStream, versionNumber);
        return new ChunkGroupHeader(deviceID);
    }

    private static IDeviceID deserializeDeviceID(InputStream inputStream, byte versionNumber) throws IOException {
        IDeviceID.Deserializer deserializer = versionNumber == 4 ? IDeviceID.Deserializer.DEFAULT_DESERIALIZER : IDeviceID.Deserializer.DESERIALIZER_V3;
        return deserializer.deserializeFrom(inputStream);
    }

    public IDeviceID getDeviceID() {
        return this.deviceID;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteIOUtils.write((byte)0, outputStream);
        return length += this.deviceID.serialize(outputStream);
    }

    public String toString() {
        return "ChunkGroupHeader{deviceID='" + this.deviceID + '\'' + ", serializedSize=" + this.serializedSize + '}';
    }
}

