/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.jvm;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.jvm.JvmUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;

public class JvmMemoryMetrics
implements IMetricSet {
    @Override
    public void bindTo(AbstractMetricService metricService) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            metricService.createAutoGauge(SystemMetric.JVM_BUFFER_COUNT_BUFFERS.toString(), MetricLevel.CORE, bufferPoolBean, BufferPoolMXBean::getCount, SystemTag.ID.toString(), bufferPoolBean.getName());
            metricService.createAutoGauge(SystemMetric.JVM_BUFFER_MEMORY_USED_BYTES.toString(), MetricLevel.CORE, bufferPoolBean, BufferPoolMXBean::getMemoryUsed, SystemTag.ID.toString(), bufferPoolBean.getName());
            metricService.createAutoGauge(SystemMetric.JVM_BUFFER_TOTAL_CAPACITY_BYTES.toString(), MetricLevel.CORE, bufferPoolBean, BufferPoolMXBean::getTotalCapacity, SystemTag.ID.toString(), bufferPoolBean.getName());
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            String area = MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap";
            metricService.createAutoGauge(SystemMetric.JVM_MEMORY_USED_BYTES.toString(), MetricLevel.CORE, memoryPoolBean, mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getUsed), SystemTag.ID.toString(), memoryPoolBean.getName(), SystemTag.AREA.toString(), area);
            metricService.createAutoGauge(SystemMetric.JVM_MEMORY_COMMITTED_BYTES.toString(), MetricLevel.CORE, memoryPoolBean, mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getCommitted), SystemTag.ID.toString(), memoryPoolBean.getName(), SystemTag.AREA.toString(), area);
            metricService.createAutoGauge(SystemMetric.JVM_MEMORY_MAX_BYTES.toString(), MetricLevel.CORE, memoryPoolBean, mem -> JvmUtils.getUsageValue(mem, MemoryUsage::getMax), SystemTag.ID.toString(), memoryPoolBean.getName(), SystemTag.AREA.toString(), area);
        }
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_BUFFER_COUNT_BUFFERS.toString(), SystemTag.ID.toString(), bufferPoolBean.getName());
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_BUFFER_MEMORY_USED_BYTES.toString(), SystemTag.ID.toString(), bufferPoolBean.getName());
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_BUFFER_TOTAL_CAPACITY_BYTES.toString(), SystemTag.ID.toString(), bufferPoolBean.getName());
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            String area = MemoryType.HEAP.equals((Object)memoryPoolBean.getType()) ? "heap" : "nonheap";
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_MEMORY_USED_BYTES.toString(), SystemTag.ID.toString(), memoryPoolBean.getName(), SystemTag.AREA.toString(), area);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_MEMORY_COMMITTED_BYTES.toString(), SystemTag.ID.toString(), memoryPoolBean.getName(), SystemTag.AREA.toString(), area);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.JVM_MEMORY_MAX_BYTES.toString(), SystemTag.ID.toString(), memoryPoolBean.getName(), SystemTag.AREA.toString(), area);
        }
    }
}

