/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.schema;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.tool.common.OptionsUtil;
import org.apache.iotdb.tool.schema.AbstractImportSchema;
import org.apache.iotdb.tool.schema.AbstractSchemaTool;
import org.apache.iotdb.tool.schema.ImportSchemaTable;
import org.apache.iotdb.tool.schema.ImportSchemaTree;

public class ImportSchema
extends AbstractSchemaTool {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);

    private static void parseSpecialParams(CommandLine commandLine) throws ArgsErrorException {
        targetPath = commandLine.getOptionValue("s");
        if (commandLine.getOptionValue("batch") != null) {
            batchPointSize = Integer.parseInt(commandLine.getOptionValue("batch"));
        }
        if (commandLine.getOptionValue("fd") != null) {
            failedFileDirectory = commandLine.getOptionValue("fd");
            File file = new File(failedFileDirectory);
            if (!file.isDirectory()) {
                file.mkdir();
                failedFileDirectory = file.getAbsolutePath() + File.separator;
            } else if (!failedFileDirectory.endsWith("/") && !failedFileDirectory.endsWith("\\")) {
                failedFileDirectory = failedFileDirectory + File.separator;
            }
        }
        if (commandLine.getOptionValue("aligned") != null) {
            aligned = Boolean.valueOf(commandLine.getOptionValue("aligned"));
        }
        if (commandLine.getOptionValue("lpf") != null) {
            linesPerFailedFile = Integer.parseInt(commandLine.getOptionValue("lpf"));
        }
        database = ImportSchema.checkRequiredArg("db", "database", commandLine, null);
        String sqlDialectValue = ImportSchema.checkRequiredArg("sql_dialect", "sql_dialect", commandLine, "tree");
        if ("table".equalsIgnoreCase(sqlDialectValue)) {
            sqlDialectTree = false;
            if (StringUtils.isBlank((CharSequence)database)) {
                ioTPrinter.println(String.format("The database param is required when sql_dialect is table ", new Object[0]));
                System.exit(1);
            } else if (StringUtils.isNotBlank((CharSequence)database) && "information_schema".equalsIgnoreCase(database)) {
                ioTPrinter.println(String.format("Does not support exporting system databases %s", database));
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) throws IoTDBConnectionException {
        Options options = OptionsUtil.createImportSchemaOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setOptionComparator(null);
        hf.setWidth(92);
        CommandLine commandLine = null;
        DefaultParser parser = new DefaultParser();
        if (args == null || args.length == 0) {
            ioTPrinter.println("Too few params input, please check the following hint.");
            hf.printHelp("ImportSchema", options, true);
            System.exit(1);
        }
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            ioTPrinter.println("Parse error: " + e.getMessage());
            hf.printHelp("ImportSchema", options, true);
            System.exit(1);
        }
        if (commandLine.hasOption("help")) {
            hf.printHelp("ImportSchema", options, true);
            System.exit(1);
        }
        try {
            ImportSchema.parseBasicParams(commandLine);
            String filename = commandLine.getOptionValue("s");
            if (filename == null) {
                hf.printHelp("ImportSchema", options, true);
                System.exit(1);
            }
            ImportSchema.parseSpecialParams(commandLine);
        }
        catch (ArgsErrorException e) {
            ioTPrinter.println("Args error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            ioTPrinter.println("Encounter an error, because: " + e.getMessage());
            System.exit(1);
        }
        System.exit(ImportSchema.importFromTargetPath());
    }

    private static int importFromTargetPath() {
        try {
            AbstractImportSchema importSchema = sqlDialectTree != false ? new ImportSchemaTree() : new ImportSchemaTable();
            importSchema.init();
            AbstractImportSchema.init(importSchema);
            return 0;
        }
        catch (InterruptedException e) {
            ioTPrinter.println(String.format("Import schema fail: %s", e.getMessage()));
            Thread.currentThread().interrupt();
            return 1;
        }
        catch (Exception e) {
            ioTPrinter.println(String.format("Import schema fail: %s", e.getMessage()));
            return 1;
        }
    }
}

