/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.record.Tablet;

public class TabletsPayload
implements SubscriptionPollPayload {
    private transient Map<String, List<Tablet>> tablets;
    private transient int nextOffset;

    public TabletsPayload() {
    }

    public TabletsPayload(List<Tablet> tablets, int nextOffset) {
        this.tablets = tablets.isEmpty() ? Collections.emptyMap() : Collections.singletonMap(null, tablets);
        this.nextOffset = nextOffset;
    }

    public TabletsPayload(Map<String, List<Tablet>> tablets, int nextOffset) {
        this.tablets = tablets;
        this.nextOffset = nextOffset;
    }

    public List<Tablet> getTablets() {
        return this.tablets.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Map<String, List<Tablet>> getTabletsWithDBInfo() {
        return this.tablets;
    }

    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.tablets.size(), (OutputStream)stream);
        for (Map.Entry<String, List<Tablet>> entry : this.tablets.entrySet()) {
            String databaseName = entry.getKey();
            List<Tablet> tabletList = entry.getValue();
            ReadWriteIOUtils.write((String)databaseName, (OutputStream)stream);
            ReadWriteIOUtils.write((int)tabletList.size(), (OutputStream)stream);
            for (Tablet tablet : tabletList) {
                tablet.serialize(stream);
            }
        }
        ReadWriteIOUtils.write((int)this.nextOffset, (OutputStream)stream);
    }

    @Override
    public SubscriptionPollPayload deserialize(ByteBuffer buffer) {
        HashMap<String, List<Tablet>> tabletsWithDBInfo = new HashMap<String, List<Tablet>>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        for (int i = 0; i < size; ++i) {
            String databaseName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
            int tabletsSize = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<Tablet> tablets = new ArrayList<Tablet>();
            for (int j = 0; j < tabletsSize; ++j) {
                tablets.add(Tablet.deserialize((ByteBuffer)buffer));
            }
            tabletsWithDBInfo.put(databaseName, tablets);
        }
        this.tablets = tabletsWithDBInfo;
        this.nextOffset = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TabletsPayload that = (TabletsPayload)obj;
        return Objects.equals(this.tablets, that.tablets) && Objects.equals(this.nextOffset, that.nextOffset);
    }

    public int hashCode() {
        return Objects.hash(this.tablets, this.nextOffset);
    }

    public String toString() {
        return "TabletsPayload{size of tablets=" + this.tablets.size() + ", nextOffset=" + this.nextOffset + "}";
    }
}

