/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.reporter.iotdb;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.metrics.impl.DoNothingMetric;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.type.IMetric;
import org.apache.iotdb.metrics.utils.IoTDBMetricsUtils;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.tsfile.enums.TSDataType;

public abstract class IoTDBReporter
implements Reporter {
    public void writeMetricToIoTDB(IMetric metric, String name, long time, String ... tags) {
        if (!(metric instanceof DoNothingMetric)) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            metric.constructValueMap(values);
            this.writeMetricToIoTDB(values, IoTDBMetricsUtils.generatePath(name, tags), time);
        }
    }

    protected abstract void writeMetricToIoTDB(Map<String, Object> var1, String var2, long var3);

    public void writeMetricToIoTDB(Map<MetricInfo, IMetric> metricMap) {
        HashMap<String, Map<String, Object>> values = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<MetricInfo, IMetric> metricEntry : metricMap.entrySet()) {
            String prefix = IoTDBMetricsUtils.generatePath(metricEntry.getKey());
            IMetric metric = metricEntry.getValue();
            if (metric instanceof DoNothingMetric) continue;
            HashMap<String, Object> value = new HashMap<String, Object>();
            metric.constructValueMap(value);
            values.put(prefix, value);
        }
        this.writeMetricsToIoTDB(values, System.currentTimeMillis());
    }

    protected abstract void writeMetricsToIoTDB(Map<String, Map<String, Object>> var1, long var2);

    protected TSDataType inferType(Object value) {
        TSDataType dataType = value instanceof Boolean ? TSDataType.BOOLEAN : (value instanceof Integer ? TSDataType.INT32 : (value instanceof Long ? TSDataType.INT64 : (value instanceof Double ? TSDataType.DOUBLE : TSDataType.TEXT)));
        return dataType;
    }
}

