/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.basic.OperatorType;
import org.apache.tsfile.read.filter.basic.TimeFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class GroupByFilter
extends TimeFilter {
    protected long startTime;
    protected long endTime;
    protected long interval;
    protected long slidingStep;

    public GroupByFilter(long startTime, long endTime, long interval, long slidingStep) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.interval = interval;
        this.slidingStep = slidingStep;
    }

    protected GroupByFilter(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public GroupByFilter(ByteBuffer buffer) {
        this.startTime = ReadWriteIOUtils.readLong(buffer);
        this.endTime = ReadWriteIOUtils.readLong(buffer);
        this.interval = ReadWriteIOUtils.readLong(buffer);
        this.slidingStep = ReadWriteIOUtils.readLong(buffer);
    }

    @Override
    public boolean timeSatisfy(long time) {
        if (time < this.startTime || time >= this.endTime) {
            return false;
        }
        return (time - this.startTime) % this.slidingStep < this.interval;
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (endTime < this.startTime || startTime >= this.endTime) {
            return false;
        }
        if (startTime <= this.startTime) {
            return true;
        }
        long minTime = startTime - this.startTime;
        long count = minTime / this.slidingStep;
        if (minTime <= this.interval + count * this.slidingStep) {
            return true;
        }
        if (this.endTime <= (count + 1L) * this.slidingStep + this.startTime) {
            return false;
        }
        return endTime >= (count + 1L) * this.slidingStep + this.startTime;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (startTime >= this.startTime && endTime <= this.endTime) {
            long minTime = startTime - this.startTime;
            long maxTime = endTime - this.startTime;
            long count = minTime / this.slidingStep;
            return minTime <= this.interval + count * this.slidingStep && maxTime <= this.interval + count * this.slidingStep;
        }
        return false;
    }

    public String toString() {
        return String.format("GroupByFilter{[%d, %d], %d, %d}", this.startTime, this.endTime, this.interval, this.slidingStep);
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        return this.startTime >= this.endTime ? Collections.emptyList() : Collections.singletonList(new TimeRange(this.startTime, this.endTime - 1L));
    }

    @Override
    public Filter reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.GROUP_BY_TIME;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
        ReadWriteIOUtils.write(this.startTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.endTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.interval, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.slidingStep, (OutputStream)outputStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupByFilter that = (GroupByFilter)o;
        return this.interval == that.interval && this.slidingStep == that.slidingStep && this.startTime == that.startTime && this.endTime == that.endTime;
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.slidingStep, this.startTime, this.endTime);
    }
}

