/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractCrossSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskMetadataInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class FastCrossSpaceCompactionEstimator
extends AbstractCrossSpaceEstimator {
    @Override
    protected long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        long maxAlignedSeriesMemCost = taskInfo.getFileInfoList().stream().mapToLong(fileInfo -> fileInfo.maxMemToReadAlignedSeries).sum();
        long maxNonAlignedSeriesMemCost = taskInfo.getFileInfoList().stream().mapToLong(fileInfo -> fileInfo.maxMemToReadNonAlignedSeries * (long)this.config.getSubCompactionTaskNum()).sum();
        cost += Math.min(Math.max(maxAlignedSeriesMemCost, maxNonAlignedSeriesMemCost), (long)(taskInfo.getFileInfoList().size() * taskInfo.getMaxChunkMetadataNumInDevice()) * taskInfo.getMaxChunkMetadataSize());
        return cost += this.fixedMemoryBudget;
    }

    @Override
    protected long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) throws IOException {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        int batchSize = this.config.getCompactionMaxAlignedSeriesNumInOneBatch();
        long maxConcurrentSeriesNum = Math.max(this.config.getSubCompactionTaskNum(), Math.min(batchSize <= 0 ? Integer.MAX_VALUE : batchSize, taskInfo.getMaxConcurrentSeriesNum()));
        long averageChunkSize = taskInfo.getTotalFileSize() / taskInfo.getTotalChunkNum();
        long maxConcurrentSeriesSizeOfTotalFiles = averageChunkSize * (long)taskInfo.getFileInfoList().size() * maxConcurrentSeriesNum * (long)taskInfo.getMaxChunkMetadataNumInSeries() + maxConcurrentSeriesNum * (long)this.tsFileConfig.getPageSizeInByte();
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * maxConcurrentSeriesNum;
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSizeOfTotalFiles, maxTargetChunkWriterSize);
        long maxConcurrentChunkSizeFromSourceFile = (averageChunkSize + (long)this.tsFileConfig.getPageSizeInByte()) * maxConcurrentSeriesNum * (long)this.calculatingMaxOverlapFileNumInSubCompactionTask(null, taskInfo.getResources());
        return targetChunkWriterSize + maxConcurrentChunkSizeFromSourceFile + taskInfo.getModificationFileSize();
    }

    @Override
    public long roughEstimateCrossCompactionMemory(CompactionScheduleContext context, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        if (this.config.getCompactionMaxAlignedSeriesNumInOneBatch() <= 0) {
            return -1L;
        }
        ArrayList<TsFileResource> sourceFiles = new ArrayList<TsFileResource>(seqResources.size() + unseqResources.size());
        sourceFiles.addAll(seqResources);
        sourceFiles.addAll(unseqResources);
        CompactionTaskMetadataInfo metadataInfo = CompactionEstimateUtils.collectMetadataInfoFromDisk(sourceFiles, CompactionType.CROSS_COMPACTION);
        int maxConcurrentSeriesNum = metadataInfo.getMaxConcurrentSeriesNum(true);
        long maxChunkSize = this.config.getTargetChunkSize();
        long maxPageSize = this.tsFileConfig.getPageSizeInByte();
        int maxOverlapFileNum = this.calculatingMaxOverlapFileNumInSubCompactionTask(context, sourceFiles);
        return (long)((maxOverlapFileNum + 1) * maxConcurrentSeriesNum) * (maxChunkSize + maxPageSize) + this.fixedMemoryBudget + metadataInfo.metadataMemCost;
    }
}

