/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class RemoveAINodeStatement
extends Statement
implements IConfigStatement {
    private final Integer nodeId;

    public RemoveAINodeStatement() {
        this.nodeId = -1;
    }

    public RemoveAINodeStatement(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        return AuthorityChecker.checkSuperUserOrMaintain(userName);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitRemoveAINode(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }
}

