/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.scheduler.AsyncSendPlanNodeHandler;
import org.apache.iotdb.db.queryengine.plan.scheduler.FailedFragmentInstanceWithStatus;
import org.apache.iotdb.mpp.rpc.thrift.TPlanNode;
import org.apache.iotdb.mpp.rpc.thrift.TSendBatchPlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeReq;
import org.apache.iotdb.mpp.rpc.thrift.TSendSinglePlanNodeResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPlanNodeSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncPlanNodeSender.class);
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;
    private final List<FragmentInstance> instances;
    private final Map<TEndPoint, BatchRequestWithIndex> batchRequests;
    private final Map<Integer, TSendSinglePlanNodeResp> instanceId2RespMap;
    private final List<Integer> needRetryInstanceIndex;
    private final AtomicLong pendingNumber;
    private long startSendTime = System.nanoTime();

    public AsyncPlanNodeSender(IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager, List<FragmentInstance> instances) {
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
        this.instances = instances;
        this.batchRequests = new HashMap<TEndPoint, BatchRequestWithIndex>();
        for (int i = 0; i < instances.size(); ++i) {
            this.batchRequests.computeIfAbsent(instances.get(i).getHostDataNode().getInternalEndPoint(), x -> new BatchRequestWithIndex()).addSinglePlanNodeReq(i, new TSendSinglePlanNodeReq(new TPlanNode(instances.get(i).getFragment().getPlanNodeTree().serializeToByteBuffer()), instances.get(i).getRegionReplicaSet().getRegionId()));
        }
        this.instanceId2RespMap = new ConcurrentHashMap<Integer, TSendSinglePlanNodeResp>(instances.size() + 1, 1.0f);
        this.needRetryInstanceIndex = Collections.synchronizedList(new ArrayList());
        this.pendingNumber = new AtomicLong(this.batchRequests.keySet().size());
    }

    public void sendAll() {
        for (Map.Entry<TEndPoint, BatchRequestWithIndex> entry : this.batchRequests.entrySet()) {
            AsyncSendPlanNodeHandler handler = new AsyncSendPlanNodeHandler(entry.getValue().getIndexes(), this.pendingNumber, this.instanceId2RespMap, this.needRetryInstanceIndex, this.startSendTime);
            try {
                AsyncDataNodeInternalServiceClient client = (AsyncDataNodeInternalServiceClient)this.asyncInternalServiceClientManager.borrowClient((Object)entry.getKey());
                client.sendBatchPlanNode(entry.getValue().getBatchRequest(), (AsyncMethodCallback)handler);
            }
            catch (Exception e) {
                handler.onError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilCompleted() throws InterruptedException {
        AtomicLong atomicLong = this.pendingNumber;
        synchronized (atomicLong) {
            while (this.pendingNumber.get() != 0L) {
                this.pendingNumber.wait();
            }
        }
    }

    public List<FailedFragmentInstanceWithStatus> getFailedInstancesWithStatuses() {
        ArrayList<FailedFragmentInstanceWithStatus> failureFragmentInstanceWithStatusList = new ArrayList<FailedFragmentInstanceWithStatus>();
        for (Map.Entry<Integer, TSendSinglePlanNodeResp> entry : this.instanceId2RespMap.entrySet()) {
            TSStatus status = entry.getValue().getStatus();
            FragmentInstance instance = this.instances.get(entry.getKey());
            if (!entry.getValue().accepted) {
                if (status == null) {
                    LOGGER.warn("dispatch write failed. message: {}, node {}", (Object)entry.getValue().message, (Object)this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint());
                    failureFragmentInstanceWithStatusList.add(new FailedFragmentInstanceWithStatus(instance, RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_ERROR, (String)entry.getValue().getMessage())));
                    continue;
                }
                LOGGER.warn("dispatch write failed. status: {}, code: {}, message: {}, node {}", new Object[]{entry.getValue().status, TSStatusCode.representOf((int)status.code), entry.getValue().message, this.instances.get(entry.getKey()).getHostDataNode().getInternalEndPoint()});
                failureFragmentInstanceWithStatusList.add(new FailedFragmentInstanceWithStatus(instance, status));
                continue;
            }
            if (status == null || status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            failureFragmentInstanceWithStatusList.add(new FailedFragmentInstanceWithStatus(instance, status));
        }
        return failureFragmentInstanceWithStatusList;
    }

    public boolean needRetry() {
        return !this.needRetryInstanceIndex.isEmpty() && this.instances.get((int)0).getRegionReplicaSet().dataNodeLocations.size() > 1;
    }

    public void retry() throws InterruptedException {
        this.batchRequests.clear();
        for (int fragmentInstanceIndex : this.needRetryInstanceIndex) {
            this.batchRequests.computeIfAbsent(this.instances.get(fragmentInstanceIndex).getNextRetriedHostDataNode().getInternalEndPoint(), x -> new BatchRequestWithIndex()).addSinglePlanNodeReq(fragmentInstanceIndex, new TSendSinglePlanNodeReq(new TPlanNode(this.instances.get(fragmentInstanceIndex).getFragment().getPlanNodeTree().serializeToByteBuffer()), this.instances.get(fragmentInstanceIndex).getRegionReplicaSet().getRegionId()));
        }
        this.needRetryInstanceIndex.clear();
        this.pendingNumber.set(this.batchRequests.keySet().size());
        this.startSendTime = System.nanoTime();
        this.sendAll();
        this.waitUntilCompleted();
    }

    static class BatchRequestWithIndex {
        private final List<Integer> indexes = new ArrayList<Integer>();
        private final TSendBatchPlanNodeReq batchRequest = new TSendBatchPlanNodeReq();

        BatchRequestWithIndex() {
        }

        void addSinglePlanNodeReq(int index, TSendSinglePlanNodeReq singleRequest) {
            this.indexes.add(index);
            this.batchRequest.addToRequests(singleRequest);
        }

        public List<Integer> getIndexes() {
            return this.indexes;
        }

        public TSendBatchPlanNodeReq getBatchRequest() {
            return this.batchRequest;
        }
    }
}

