/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.type;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeId;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeManager;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignature;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureParameter;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.BinaryType;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DateType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeEnum;
import org.apache.tsfile.read.common.type.UnknownType;

public class InternalTypeManager
implements TypeManager {
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();

    public InternalTypeManager() {
        this.types.put(new TypeSignature(TypeEnum.DOUBLE.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)DoubleType.DOUBLE);
        this.types.put(new TypeSignature(TypeEnum.FLOAT.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)FloatType.FLOAT);
        this.types.put(new TypeSignature(TypeEnum.INT64.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)LongType.INT64);
        this.types.put(new TypeSignature(TypeEnum.INT32.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)IntType.INT32);
        this.types.put(new TypeSignature(TypeEnum.BOOLEAN.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)BooleanType.BOOLEAN);
        this.types.put(new TypeSignature(TypeEnum.TEXT.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)BinaryType.TEXT);
        this.types.put(new TypeSignature(TypeEnum.STRING.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)StringType.STRING);
        this.types.put(new TypeSignature(TypeEnum.BLOB.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)BlobType.BLOB);
        this.types.put(new TypeSignature(TypeEnum.DATE.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)DateType.DATE);
        this.types.put(new TypeSignature(TypeEnum.TIMESTAMP.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)TimestampType.TIMESTAMP);
        this.types.put(new TypeSignature(TypeEnum.UNKNOWN.name().toLowerCase(Locale.ENGLISH), new TypeSignatureParameter[0]), (Type)UnknownType.UNKNOWN);
    }

    @Override
    public Type getType(TypeSignature signature) throws TypeNotFoundException {
        Type type = (Type)this.types.get(signature);
        if (type == null) {
            throw new TypeNotFoundException(signature);
        }
        return type;
    }

    @Override
    public Type fromSqlType(String type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getType(TypeId id) {
        throw new UnsupportedOperationException();
    }

    public static TSDataType getTSDataType(Type type) {
        if (type == null) {
            return null;
        }
        TypeEnum typeEnum = type.getTypeEnum();
        switch (typeEnum) {
            case TEXT: {
                return TSDataType.TEXT;
            }
            case FLOAT: {
                return TSDataType.FLOAT;
            }
            case DOUBLE: {
                return TSDataType.DOUBLE;
            }
            case INT32: {
                return TSDataType.INT32;
            }
            case INT64: {
                return TSDataType.INT64;
            }
            case BOOLEAN: {
                return TSDataType.BOOLEAN;
            }
            case UNKNOWN: {
                return TSDataType.UNKNOWN;
            }
            case DATE: {
                return TSDataType.DATE;
            }
            case TIMESTAMP: {
                return TSDataType.TIMESTAMP;
            }
            case BLOB: 
            case ROW: {
                return TSDataType.BLOB;
            }
            case STRING: {
                return TSDataType.STRING;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Type fromTSDataType(TSDataType dataType) {
        switch (dataType) {
            case TEXT: {
                return BinaryType.TEXT;
            }
            case FLOAT: {
                return FloatType.FLOAT;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case INT32: {
                return IntType.INT32;
            }
            case INT64: {
                return LongType.INT64;
            }
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case UNKNOWN: {
                return UnknownType.UNKNOWN;
            }
            case DATE: {
                return DateType.DATE;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case BLOB: {
                return BlobType.BLOB;
            }
            case STRING: {
                return StringType.STRING;
            }
        }
        throw new IllegalArgumentException();
    }
}

