/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CreateDB;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Property;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.DatabaseSchemaStatement;

public abstract class DatabaseStatement
extends Statement {
    protected final boolean exists;
    protected final String dbName;
    protected final List<Property> properties;

    protected DatabaseStatement(NodeLocation location, boolean exists, String dbName, List<Property> properties) {
        super(Objects.requireNonNull(location, "location is null"));
        this.exists = exists;
        this.dbName = Objects.requireNonNull(dbName, "dbName is null").toLowerCase(Locale.ENGLISH);
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean exists() {
        return this.exists;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public abstract DatabaseSchemaStatement.DatabaseSchemaStatementType getType();

    public List<Node> getChildren() {
        return ImmutableList.copyOf(this.properties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dbName, this.exists, this.properties);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateDB o = (CreateDB)obj;
        return Objects.equals(this.dbName, o.dbName) && Objects.equals(this.exists, o.exists) && Objects.equals(this.properties, o.properties);
    }
}

