/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.metadata;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.MetadataUtil;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedTablePrefix;

@Immutable
public class QualifiedObjectName {
    private static final Pattern UNQUOTED_COMPONENT = Pattern.compile("[a-zA-Z0-9_]+");
    private static final String COMPONENT = UNQUOTED_COMPONENT.pattern() + "|\"([^\"]|\"\")*\"";
    private static final Pattern PATTERN = Pattern.compile("(?<database>" + COMPONENT + ")\\.(?<table>" + COMPONENT + ")");
    private final String dbName;
    private final String objectName;

    public static QualifiedObjectName valueOf(String name) {
        Objects.requireNonNull(name, "name is null");
        Matcher matcher = PATTERN.matcher(name);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid name %s", (Object)name);
        return new QualifiedObjectName(QualifiedObjectName.unquoteIfNeeded(matcher.group("database")), QualifiedObjectName.unquoteIfNeeded(matcher.group("table")));
    }

    public QualifiedObjectName(String dbName, String objectName) {
        MetadataUtil.checkObjectName(dbName, objectName);
        this.dbName = dbName;
        this.objectName = objectName;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public QualifiedTablePrefix asQualifiedTablePrefix() {
        return new QualifiedTablePrefix(this.dbName, this.objectName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedObjectName o = (QualifiedObjectName)obj;
        return Objects.equals(this.dbName, o.dbName) && Objects.equals(this.objectName, o.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.dbName, this.objectName);
    }

    public String toString() {
        return QualifiedObjectName.quoteIfNeeded(this.dbName) + '.' + QualifiedObjectName.quoteIfNeeded(this.objectName);
    }

    private static String unquoteIfNeeded(String name) {
        if (name.isEmpty() || name.charAt(0) != '\"') {
            return name;
        }
        Preconditions.checkArgument((name.charAt(name.length() - 1) == '\"' ? 1 : 0) != 0, (String)"Invalid name: [%s]", (Object)name);
        return name.substring(1, name.length() - 1).replace("\"\"", "\"");
    }

    private static String quoteIfNeeded(String name) {
        if (UNQUOTED_COMPONENT.matcher(name).matches()) {
            return name;
        }
        return "\"" + name.replace("\"", "\"\"") + "\"";
    }
}

