/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.tsfile.read.common.type.Type;

public class Field {
    private final Optional<QualifiedObjectName> originTable;
    private final Optional<String> originColumnName;
    private final Optional<QualifiedName> relationAlias;
    private final Optional<String> name;
    private final Type type;
    private final TsTableColumnCategory columnCategory;
    private final boolean hidden;
    private final boolean aliased;

    public static Field newUnqualified(String name, Type type, TsTableColumnCategory columnCategory) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(Optional.empty(), Optional.of(name), type, columnCategory, false, Optional.empty(), Optional.empty(), false);
    }

    public static Field newUnqualified(Optional<String> name, Type type, TsTableColumnCategory columnCategory) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        return new Field(Optional.empty(), name, type, columnCategory, false, Optional.empty(), Optional.empty(), false);
    }

    public static Field newUnqualified(Optional<String> name, Type type, TsTableColumnCategory columnCategory, Optional<QualifiedObjectName> originTable, Optional<String> originColumn, boolean aliased) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(originTable, "originTable is null");
        return new Field(Optional.empty(), name, type, columnCategory, false, originTable, originColumn, aliased);
    }

    public static Field newQualified(QualifiedName relationAlias, Optional<String> name, Type type, TsTableColumnCategory columnCategory, boolean hidden, Optional<QualifiedObjectName> originTable, Optional<String> originColumn, boolean aliased) {
        Objects.requireNonNull(relationAlias, "relationAlias is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(originTable, "originTable is null");
        return new Field(Optional.of(relationAlias), name, type, columnCategory, hidden, originTable, originColumn, aliased);
    }

    public Field(Optional<QualifiedName> relationAlias, Optional<String> name, Type type, TsTableColumnCategory columnCategory, boolean hidden, Optional<QualifiedObjectName> originTable, Optional<String> originColumnName, boolean aliased) {
        Objects.requireNonNull(relationAlias, "relationAlias is null");
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(originTable, "originTable is null");
        Objects.requireNonNull(originColumnName, "originColumnName is null");
        this.relationAlias = relationAlias;
        this.name = name;
        this.type = type;
        this.columnCategory = columnCategory;
        this.hidden = hidden;
        this.originTable = originTable;
        this.originColumnName = originColumnName;
        this.aliased = aliased;
    }

    public Optional<QualifiedObjectName> getOriginTable() {
        return this.originTable;
    }

    public Optional<String> getOriginColumnName() {
        return this.originColumnName;
    }

    public Optional<QualifiedName> getRelationAlias() {
        return this.relationAlias;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public TsTableColumnCategory getColumnCategory() {
        return this.columnCategory;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isAliased() {
        return this.aliased;
    }

    public boolean matchesPrefix(Optional<QualifiedName> prefix) {
        return !prefix.isPresent() || this.relationAlias.isPresent() && this.relationAlias.get().hasSuffix(prefix.get());
    }

    public boolean canResolve(QualifiedName name) {
        if (!this.name.isPresent()) {
            return false;
        }
        return this.matchesPrefix(name.getPrefix()) && this.name.get().equalsIgnoreCase(name.getSuffix());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.relationAlias.isPresent()) {
            result.append(this.relationAlias.get()).append(".");
        }
        result.append(this.name.orElse("<anonymous>")).append(":").append(this.type);
        return result.toString();
    }
}

