/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.ai;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.confignode.rpc.thrift.TShowModelResp;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.BytesUtils;

public class ShowModelsTask
implements IConfigTask {
    private final String modelName;
    public static final String INPUT_SHAPE = "inputShape:";
    public static final String OUTPUT_SHAPE = "outputShape:";
    public static final String INPUT_DATA_TYPE = "inputDataType:";
    public static final String OUTPUT_DATA_TYPE = "outputDataType:";
    private static final String EMPTY_STRING = "";

    public ShowModelsTask(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showModels(this.modelName);
    }

    public static void buildTsBlock(TShowModelResp resp, SettableFuture<ConfigTaskResult> future) {
        List modelIdList = resp.getModelIdList();
        Map modelTypeMap = resp.getModelTypeMap();
        Map categoryMap = resp.getCategoryMap();
        Map stateMap = resp.getStateMap();
        List outputDataTypes = ColumnHeaderConstant.showModelsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (String modelId : modelIdList) {
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(BytesUtils.valueOf((String)modelId));
            builder.getColumnBuilder(1).writeBinary(BytesUtils.valueOf((String)((String)modelTypeMap.get(modelId))));
            builder.getColumnBuilder(2).writeBinary(BytesUtils.valueOf((String)((String)categoryMap.get(modelId))));
            builder.getColumnBuilder(3).writeBinary(BytesUtils.valueOf((String)((String)stateMap.get(modelId))));
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowModelsHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

