/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.util.List;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.comparator.JoinKeyComparator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.AbstractMergeSortJoinOperator;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.RamUsageEstimator;

public class MergeSortInnerJoinOperator
extends AbstractMergeSortJoinOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(MergeSortInnerJoinOperator.class);

    public MergeSortInnerJoinOperator(OperatorContext operatorContext, Operator leftChild, int[] leftJoinKeyPositions, int[] leftOutputSymbolIdx, Operator rightChild, int[] rightJoinKeyPositions, int[] rightOutputSymbolIdx, List<JoinKeyComparator> joinKeyComparators, List<TSDataType> dataTypes) {
        super(operatorContext, leftChild, leftJoinKeyPositions, leftOutputSymbolIdx, rightChild, rightJoinKeyPositions, rightOutputSymbolIdx, joinKeyComparators, dataTypes);
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.retainedTsBlock != null) {
            return true;
        }
        return !this.leftFinished && !this.rightFinished;
    }

    @Override
    protected boolean prepareInput() throws Exception {
        this.gotCandidateBlocks();
        return this.leftBlockNotEmpty() && this.rightBlockNotEmpty() && this.gotNextRightBlock();
    }

    @Override
    protected boolean processFinished() {
        if (this.allRightLessThanLeft()) {
            this.resetRightBlockList();
            return true;
        }
        if (this.allLeftLessThanRight()) {
            this.resetLeftBlock();
            return true;
        }
        while (this.currentRightHasNullValue()) {
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        while (this.lessThan((TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex, this.leftBlock, this.leftJoinKeyPositions, this.leftIndex)) {
            if (!this.rightFinishedWithIncIndex()) continue;
            return true;
        }
        if (this.currentRoundNeedStop()) {
            return true;
        }
        while (this.currentLeftHasNullValue()) {
            if (!this.leftFinishedWithIncIndex()) continue;
            return true;
        }
        while (this.lessThan(this.leftBlock, this.leftJoinKeyPositions, this.leftIndex, (TsBlock)this.rightBlockList.get(this.rightBlockListIdx), this.rightJoinKeyPositions, this.rightIndex)) {
            if (!this.leftFinishedWithIncIndex()) continue;
            return true;
        }
        if (this.currentRoundNeedStop()) {
            return true;
        }
        return this.hasMatchedRightValueToProbeLeft() && this.leftFinishedWithIncIndex();
    }

    @Override
    protected boolean lessThan(TsBlock leftBlock, int[] leftPositions, int lIndex, TsBlock rightBlock, int[] rightPositions, int rIndex) {
        if (rightPositions.length == 1 && rightBlock.getColumn(rightPositions[0]).isNull(rIndex)) {
            return true;
        }
        return this.examineLessThan(leftBlock, leftPositions, lIndex, rightBlock, rightPositions, rIndex);
    }

    @Override
    protected void recordsWhenDataMatches() {
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.leftChild) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.rightChild) + RamUsageEstimator.sizeOf((int[])this.leftOutputSymbolIdx) + RamUsageEstimator.sizeOf((int[])this.rightOutputSymbolIdx) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.resultBuilder.getRetainedSizeInBytes();
    }
}

