/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DevicePredicateHandler;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info.TableDeviceInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowDevicesResult;
import org.apache.tsfile.utils.Binary;

public abstract class DeviceUpdater
extends DevicePredicateHandler {
    private final BiFunction<Integer, String, Binary> attributeProvider;

    protected DeviceUpdater(List<LeafColumnTransformer> filterLeafColumnTransformerList, ColumnTransformer filterOutputTransformer, List<TsTableColumnSchema> columnSchemaList, BiFunction<Integer, String, Binary> attributeProvider, String database, TsTable table) {
        super(filterLeafColumnTransformerList, filterOutputTransformer, columnSchemaList, database, table);
        this.attributeProvider = attributeProvider;
    }

    public void handleDeviceNode(IDeviceMNode<IMemMNode> node) throws MetadataException {
        ShowDevicesResult result = new ShowDevicesResult(null, node.isAlignedNullable(), node.getSchemaTemplateId(), node.getPartialPath().getNodes());
        int pointer = ((TableDeviceInfo)node.getDeviceInfo()).getAttributePointer();
        result.setAttributeProvider(k -> this.attributeProvider.apply(pointer, (String)k));
        this.addBatch(result);
        if (this.hasComputedResult()) {
            this.update();
        }
    }

    protected abstract void update() throws MetadataException;

    @Override
    public void close() throws MetadataException {
        this.prepareBatchResult();
        if (this.hasComputedResult()) {
            this.update();
        }
        super.close();
    }
}

