/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.pipe.consensus.metric.PipeConsensusSinkMetrics;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.PipeConsensusAsyncSink;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.async.handler.PipeTransferTabletInsertionEventHandler;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeConsensusTabletInsertionEventHandler<E extends TPipeConsensusTransferResp>
implements AsyncMethodCallback<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusTabletInsertionEventHandler.class);
    protected final TabletInsertionEvent event;
    protected final TPipeConsensusTransferReq req;
    protected final PipeConsensusAsyncSink connector;
    protected final PipeConsensusSinkMetrics metric;
    private final long createTime;

    protected PipeConsensusTabletInsertionEventHandler(TabletInsertionEvent event, TPipeConsensusTransferReq req, PipeConsensusAsyncSink connector, PipeConsensusSinkMetrics metric) {
        this.event = event;
        this.req = req;
        this.connector = connector;
        this.metric = metric;
        this.createTime = System.nanoTime();
    }

    public void transfer(AsyncPipeConsensusServiceClient client) throws TException {
        this.doTransfer(client, this.req);
    }

    protected abstract void doTransfer(AsyncPipeConsensusServiceClient var1, TPipeConsensusTransferReq var2) throws TException;

    public void onComplete(TPipeConsensusTransferResp response) {
        if (response == null) {
            this.onError((Exception)((Object)new PipeException("TPipeConsensusTransferResp is null")));
            return;
        }
        TSStatus status = response.getStatus();
        try {
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                this.connector.statusHandler().handle(status, status.getMessage(), this.event.toString());
            }
            if (this.event instanceof EnrichedEvent) {
                ((EnrichedEvent)this.event).decreaseReferenceCount(PipeTransferTabletInsertionEventHandler.class.getName(), true);
            }
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                LOGGER.info("InsertNodeTransfer: no.{} event successfully processed!", (Object)((EnrichedEvent)this.event).getReplicateIndexForIoTV2());
            }
            this.connector.removeEventFromBuffer((EnrichedEvent)this.event);
            long duration = System.nanoTime() - this.createTime;
            this.metric.recordConnectorWalTransferTimer(duration);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public void onError(Exception exception) {
        EnrichedEvent event = (EnrichedEvent)this.event;
        LOGGER.warn("Failed to transfer TabletInsertionEvent {} (committer key={}, replicate index={}).", new Object[]{event.coreReportMessage(), event.getCommitterKey(), event.getReplicateIndexForIoTV2(), exception});
        if (RetryUtils.needRetryWithIncreasingInterval((Exception)exception)) {
            if (event.getRetryInterval() << 2 <= 0L) {
                event.setRetryInterval(20000L);
            } else {
                event.setRetryInterval(Math.min(20000L, event.getRetryInterval() << 2));
            }
        }
        this.connector.addFailureEventToRetryQueue(event);
        this.metric.recordRetryCounter();
    }
}

