/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.transform.converter;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.db.utils.TypeInferenceUtils;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.DateUtils;

public class ValueConverter {
    private static final Converter[][] CONVERTER = new Converter[TSDataType.values().length][TSDataType.values().length];
    private static final Converter DO_NOTHING_CONVERTER = (sourceDataType, targetDataType, sourceValue) -> sourceValue;
    private static final Binary BINARY_TRUE;
    private static final Binary BINARY_FALSE;
    private static final int TRUE_DATE;
    private static final int FALSE_DATE;
    private static final int DEFAULT_DATE;

    public static Object convert(TSDataType sourceDataType, TSDataType targetDataType, Object sourceValue) {
        return sourceValue == null ? null : CONVERTER[sourceDataType.ordinal()][targetDataType.ordinal()].convert(sourceDataType, targetDataType, sourceValue);
    }

    public static int convertBooleanToInt32(boolean value) {
        return value ? 1 : 0;
    }

    public static long convertBooleanToInt64(boolean value) {
        return value ? 1L : 0L;
    }

    public static float convertBooleanToFloat(boolean value) {
        return value ? 1.0f : 0.0f;
    }

    public static double convertBooleanToDouble(boolean value) {
        return value ? 1.0 : 0.0;
    }

    public static Binary convertBooleanToText(boolean value) {
        return value ? BINARY_TRUE : BINARY_FALSE;
    }

    public static long convertBooleanToTimestamp(boolean value) {
        return value ? 1L : 0L;
    }

    public static int convertBooleanToDate(boolean value) {
        return value ? TRUE_DATE : FALSE_DATE;
    }

    public static Binary convertBooleanToBlob(boolean value) {
        return value ? BINARY_TRUE : BINARY_FALSE;
    }

    public static Binary convertBooleanToString(boolean value) {
        return value ? BINARY_TRUE : BINARY_FALSE;
    }

    public static boolean convertInt32ToBoolean(int value) {
        return value != 0;
    }

    public static long convertInt32ToInt64(int value) {
        return value;
    }

    public static float convertInt32ToFloat(int value) {
        return value;
    }

    public static double convertInt32ToDouble(int value) {
        return value;
    }

    public static Binary convertInt32ToText(int value) {
        return ValueConverter.parseText(Integer.toString(value));
    }

    public static long convertInt32ToTimestamp(int value) {
        return value;
    }

    public static int convertInt32ToDate(int value) {
        try {
            DateUtils.parseIntToLocalDate((int)value);
            return value;
        }
        catch (Exception e) {
            return DEFAULT_DATE;
        }
    }

    public static Binary convertInt32ToBlob(int value) {
        return ValueConverter.parseBlob(Integer.toString(value));
    }

    public static Binary convertInt32ToString(int value) {
        return ValueConverter.parseString(Integer.toString(value));
    }

    public static boolean convertInt64ToBoolean(long value) {
        return value != 0L;
    }

    public static int convertInt64ToInt32(long value) {
        return (int)value;
    }

    public static float convertInt64ToFloat(long value) {
        return value;
    }

    public static double convertInt64ToDouble(long value) {
        return value;
    }

    public static Binary convertInt64ToText(long value) {
        return ValueConverter.parseText(Long.toString(value));
    }

    public static long convertInt64ToTimestamp(long value) {
        return value;
    }

    public static int convertInt64ToDate(long value) {
        try {
            int data = (int)value;
            DateUtils.parseIntToLocalDate((int)data);
            return data;
        }
        catch (Exception e) {
            return DEFAULT_DATE;
        }
    }

    public static Binary convertInt64ToBlob(long value) {
        return ValueConverter.parseBlob(Long.toString(value));
    }

    public static Binary convertInt64ToString(long value) {
        return ValueConverter.parseString(Long.toString(value));
    }

    public static boolean convertFloatToBoolean(float value) {
        return value != 0.0f;
    }

    public static int convertFloatToInt32(float value) {
        return (int)value;
    }

    public static long convertFloatToInt64(float value) {
        return (long)value;
    }

    public static double convertFloatToDouble(float value) {
        return value;
    }

    public static Binary convertFloatToText(float value) {
        return ValueConverter.parseText(Float.toString(value));
    }

    public static long convertFloatToTimestamp(float value) {
        return (long)value;
    }

    public static int convertFloatToDate(float value) {
        try {
            int data = (int)value;
            DateUtils.parseIntToLocalDate((int)data);
            return data;
        }
        catch (Exception e) {
            return DEFAULT_DATE;
        }
    }

    public static Binary convertFloatToBlob(float value) {
        return ValueConverter.parseBlob(Float.toString(value));
    }

    public static Binary convertFloatToString(float value) {
        return ValueConverter.parseString(Float.toString(value));
    }

    public static boolean convertDoubleToBoolean(double value) {
        return value != 0.0;
    }

    public static int convertDoubleToInt32(double value) {
        return (int)value;
    }

    public static long convertDoubleToInt64(double value) {
        return (long)value;
    }

    public static float convertDoubleToFloat(double value) {
        return (float)value;
    }

    public static Binary convertDoubleToText(double value) {
        return ValueConverter.parseText(Double.toString(value));
    }

    public static long convertDoubleToTimestamp(double value) {
        return (long)value;
    }

    public static int convertDoubleToDate(double value) {
        try {
            int data = (int)value;
            DateUtils.parseIntToLocalDate((int)data);
            return data;
        }
        catch (Exception e) {
            return DEFAULT_DATE;
        }
    }

    public static Binary convertDoubleToBlob(double value) {
        return ValueConverter.parseBlob(Double.toString(value));
    }

    public static Binary convertDoubleToString(double value) {
        return ValueConverter.parseString(Double.toString(value));
    }

    public static boolean convertTextToBoolean(Binary value) {
        return Boolean.parseBoolean(value.toString());
    }

    public static int convertTextToInt32(Binary value) {
        return (int)ValueConverter.parseDouble(value.toString());
    }

    public static long convertTextToInt64(Binary value) {
        return (long)ValueConverter.parseDouble(value.toString());
    }

    public static float convertTextToFloat(Binary value) {
        return ValueConverter.parseFloat(value.toString());
    }

    public static double convertTextToDouble(Binary value) {
        return ValueConverter.parseDouble(value.toString());
    }

    public static long convertTextToTimestamp(Binary value) {
        return ValueConverter.parseTimestamp(value.toString());
    }

    public static int convertTextToDate(Binary value) {
        return ValueConverter.parseDate(value.toString());
    }

    public static Binary convertTextToBlob(Binary value) {
        return value;
    }

    public static Binary convertTextToString(Binary value) {
        return value;
    }

    public static boolean convertTimestampToBoolean(long value) {
        return value != 0L;
    }

    public static int convertTimestampToInt32(long value) {
        return (int)value;
    }

    public static long convertTimestampToInt64(long value) {
        return value;
    }

    public static float convertTimestampToFloat(long value) {
        return value;
    }

    public static double convertTimestampToDouble(long value) {
        return value;
    }

    public static Binary convertTimestampToText(long value) {
        return ValueConverter.parseText(Long.toString(value));
    }

    public static int convertTimestampToDate(long value) {
        try {
            Instant instant = Instant.ofEpochMilli(value);
            return DateUtils.parseDateExpressionToInt((LocalDate)instant.atZone(ZoneOffset.UTC).toLocalDate());
        }
        catch (Exception e) {
            return DEFAULT_DATE;
        }
    }

    public static Binary convertTimestampToBlob(long value) {
        return ValueConverter.parseBlob(Long.toString(value));
    }

    public static Binary convertTimestampToString(long value) {
        return ValueConverter.parseString(Long.toString(value));
    }

    public static boolean convertDateToBoolean(int value) {
        return value != FALSE_DATE;
    }

    public static int convertDateToInt32(int value) {
        return value;
    }

    public static long convertDateToInt64(int value) {
        return value;
    }

    public static float convertDateToFloat(int value) {
        return value;
    }

    public static double convertDateToDouble(int value) {
        return value;
    }

    public static Binary convertDateToText(int value) {
        return ValueConverter.parseText(Integer.toString(value));
    }

    public static long convertDateToTimestamp(int value) {
        try {
            LocalDate date = DateUtils.parseIntToLocalDate((int)value);
            ZonedDateTime dateTime = date.atStartOfDay(ZoneOffset.UTC);
            Instant instant = dateTime.toInstant();
            return instant.toEpochMilli();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static Binary convertDateToBlob(int value) {
        return ValueConverter.parseBlob(Integer.toString(value));
    }

    public static Binary convertDateToString(int value) {
        return ValueConverter.parseString(Integer.toString(value));
    }

    public static boolean convertBlobToBoolean(Binary value) {
        return Boolean.parseBoolean(value.toString());
    }

    public static int convertBlobToInt32(Binary value) {
        return (int)ValueConverter.parseDouble(value.toString());
    }

    public static long convertBlobToInt64(Binary value) {
        return (long)ValueConverter.parseDouble(value.toString());
    }

    public static float convertBlobToFloat(Binary value) {
        return ValueConverter.parseFloat(value.toString());
    }

    public static double convertBlobToDouble(Binary value) {
        return ValueConverter.parseDouble(value.toString());
    }

    public static long convertBlobToTimestamp(Binary value) {
        return ValueConverter.parseTimestamp(value.toString());
    }

    public static int convertBlobToDate(Binary value) {
        return ValueConverter.parseDate(value.toString());
    }

    public static Binary convertBlobToString(Binary value) {
        return value;
    }

    public static Binary convertBlobToText(Binary value) {
        return value;
    }

    public static boolean convertStringToBoolean(Binary value) {
        return Boolean.parseBoolean(value.toString());
    }

    public static int convertStringToInt32(Binary value) {
        return (int)ValueConverter.parseDouble(value.toString());
    }

    public static long convertStringToInt64(Binary value) {
        return (long)ValueConverter.parseDouble(value.toString());
    }

    public static float convertStringToFloat(Binary value) {
        return ValueConverter.parseFloat(value.toString());
    }

    public static double convertStringToDouble(Binary value) {
        return ValueConverter.parseDouble(value.toString());
    }

    public static long convertStringToTimestamp(Binary value) {
        return ValueConverter.parseTimestamp(value.toString());
    }

    public static int convertStringToDate(Binary value) {
        return ValueConverter.parseDate(value.toString());
    }

    public static Binary convertStringToBlob(Binary value) {
        return value;
    }

    public static Binary convertStringToText(Binary value) {
        return value;
    }

    public static Object parse(String value, TSDataType dataType) {
        if (value == null) {
            return null;
        }
        switch (dataType) {
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case INT32: {
                return ValueConverter.parseInteger(value);
            }
            case INT64: {
                return ValueConverter.parseLong(value);
            }
            case FLOAT: {
                return Float.valueOf(ValueConverter.parseFloat(value));
            }
            case DOUBLE: {
                return ValueConverter.parseDouble(value);
            }
            case TEXT: {
                return ValueConverter.parseText(value);
            }
            case TIMESTAMP: {
                return ValueConverter.parseTimestamp(value);
            }
            case DATE: {
                return ValueConverter.parseDate(value);
            }
            case BLOB: {
                return ValueConverter.parseBlob(value);
            }
            case STRING: {
                return ValueConverter.parseString(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + dataType);
    }

    private static Binary parseBlob(String value) {
        return new Binary(value, TSFileConfig.STRING_CHARSET);
    }

    private static int parseInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static float parseFloat(String value) {
        try {
            return Float.parseFloat(value);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    private static double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private static long parseTimestamp(String value) {
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        try {
            return TypeInferenceUtils.isNumber(value) ? Long.parseLong(value) : DateTimeUtils.parseDateTimeExpressionToLong(StringUtils.trim((String)value), ZoneOffset.UTC);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static int parseDate(String value) {
        if (value == null || value.isEmpty()) {
            return DEFAULT_DATE;
        }
        try {
            if (TypeInferenceUtils.isNumber(value)) {
                int date = Integer.parseInt(value);
                DateUtils.parseIntToLocalDate((int)date);
                return date;
            }
            return DateTimeUtils.parseDateExpressionToInt(StringUtils.trim((String)value));
        }
        catch (Exception e) {
            return DEFAULT_DATE;
        }
    }

    private static Binary parseString(String value) {
        return new Binary(value, TSFileConfig.STRING_CHARSET);
    }

    private static Binary parseText(String value) {
        return new Binary(value, TSFileConfig.STRING_CHARSET);
    }

    private ValueConverter() {
    }

    static {
        for (TSDataType sourceDataType2 : TSDataType.values()) {
            for (TSDataType targetDataType2 : TSDataType.values()) {
                ValueConverter.CONVERTER[sourceDataType2.ordinal()][targetDataType2.ordinal()] = DO_NOTHING_CONVERTER;
            }
        }
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.BOOLEAN.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToInt32((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToInt64((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertBooleanToFloat((Boolean)sourceValue));
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToDouble((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToText((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToTimestamp((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToDate((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToBlob((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BOOLEAN.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBooleanToString((Boolean)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToBoolean((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.INT32.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToInt64((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertInt32ToFloat((Integer)sourceValue));
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToDouble((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToText((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToTimestamp((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToDate((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToBlob((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT32.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt32ToString((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToBoolean((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToInt32((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.INT64.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertInt64ToFloat((Long)sourceValue));
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToDouble((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToText((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToTimestamp((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToDate((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToBlob((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.INT64.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertInt64ToString((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToBoolean(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToInt32(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToInt64(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.FLOAT.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToDouble(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToText(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToTimestamp(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToDate(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToBlob(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.FLOAT.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertFloatToString(((Float)sourceValue).floatValue());
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToBoolean((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToInt32((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToInt64((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertDoubleToFloat((Double)sourceValue));
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.DOUBLE.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToText((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToTimestamp((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToDate((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToBlob((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DOUBLE.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDoubleToString((Double)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToBoolean((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToInt32((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToInt64((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertTextToFloat((Binary)sourceValue));
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToDouble((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.TEXT.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToTimestamp((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToDate((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToBlob((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TEXT.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTextToString((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToBoolean((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToInt32((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToInt64((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertTimestampToFloat((Long)sourceValue));
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToDouble((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToText((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.TIMESTAMP.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToDate((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToBlob((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.TIMESTAMP.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertTimestampToString((Long)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToBoolean((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToInt32((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToInt64((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertDateToFloat((Integer)sourceValue));
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToDouble((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToText((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToTimestamp((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.DATE.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToBlob((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.DATE.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertDateToString((Integer)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToBoolean((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToInt32((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToInt64((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertBlobToFloat((Binary)sourceValue));
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToDouble((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToText((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToTimestamp((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToDate((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.BLOB.ordinal()] = DO_NOTHING_CONVERTER;
        ValueConverter.CONVERTER[TSDataType.BLOB.ordinal()][TSDataType.STRING.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertBlobToString((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.BOOLEAN.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToBoolean((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.INT32.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToInt32((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.INT64.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToInt64((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.FLOAT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> Float.valueOf(ValueConverter.convertStringToFloat((Binary)sourceValue));
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.DOUBLE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToDouble((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.TEXT.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToText((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.TIMESTAMP.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToTimestamp((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.DATE.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToDate((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.BLOB.ordinal()] = (sourceDataType, targetDataType, sourceValue) -> ValueConverter.convertStringToBlob((Binary)sourceValue);
        ValueConverter.CONVERTER[TSDataType.STRING.ordinal()][TSDataType.STRING.ordinal()] = DO_NOTHING_CONVERTER;
        BINARY_TRUE = ValueConverter.parseString(Boolean.TRUE.toString());
        BINARY_FALSE = ValueConverter.parseString(Boolean.FALSE.toString());
        TRUE_DATE = DateUtils.parseDateExpressionToInt((LocalDate)LocalDate.of(1970, 1, 2));
        FALSE_DATE = DateUtils.parseDateExpressionToInt((LocalDate)LocalDate.of(1970, 1, 1));
        DEFAULT_DATE = DateUtils.parseDateExpressionToInt((LocalDate)LocalDate.of(1970, 1, 1));
    }

    @FunctionalInterface
    private static interface Converter {
        public Object convert(TSDataType var1, TSDataType var2, Object var3);
    }
}

