/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.terminate;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TablePattern;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;

public class PipeTerminateEvent
extends EnrichedEvent {
    private final int dataRegionId;
    private final boolean shouldMark;
    private static final ExecutorService terminateExecutor = new WrappedThreadPoolExecutor(0, IoTDBDescriptor.getInstance().getConfig().getPipeTaskThreadCount(), 0L, TimeUnit.SECONDS, new ArrayBlockingQueue(IoTDBDescriptor.getInstance().getConfig().getPipeTaskThreadCount()), new IoTThreadFactory(ThreadName.PIPE_TERMINATE_EXECUTION_POOL.getName()), ThreadName.PIPE_TERMINATE_EXECUTION_POOL.getName());

    public PipeTerminateEvent(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, int dataRegionId, boolean shouldMark) {
        super(pipeName, creationTime, pipeTaskMeta, null, null, null, true, Long.MIN_VALUE, Long.MAX_VALUE);
        this.dataRegionId = dataRegionId;
        this.shouldMark = shouldMark;
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    public ProgressIndex getProgressIndex() {
        return MinimumProgressIndex.INSTANCE;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, long creationTime, PipeTaskMeta pipeTaskMeta, TreePattern treePattern, TablePattern tablePattern, String userName, boolean skipIfNoPrivileges, long startTime, long endTime) {
        return new PipeTerminateEvent(pipeName, creationTime, pipeTaskMeta, this.dataRegionId, this.shouldMark);
    }

    public boolean isGeneratedByPipe() {
        return false;
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        return true;
    }

    public boolean mayEventPathsOverlappedWithPattern() {
        return true;
    }

    public void reportProgress() {
        if (this.shouldMark) {
            terminateExecutor.submit(() -> PipeDataNodeAgent.task().markCompleted(this.pipeName, this.dataRegionId));
        }
    }

    public String toString() {
        return String.format("PipeTerminateEvent{dataRegionId=%s, shouldMark=%s}", this.dataRegionId, this.shouldMark) + " - " + super.toString();
    }
}

