/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table.argument;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import org.apache.iotdb.udf.api.relational.table.argument.Argument;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.utils.Binary;

public class ScalarArgument
implements Argument {
    private final Type type;
    private final Object value;

    public ScalarArgument(Type type, Object value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void serialize(ByteBuffer buffer) {
        buffer.putInt(Argument.ArgumentType.SCALAR_ARGUMENT.ordinal());
        buffer.put(this.type.getType());
        switch (this.type) {
            case BOOLEAN: {
                buffer.put((Boolean)this.value != false ? (byte)1 : 0);
                break;
            }
            case INT32: {
                buffer.putInt((Integer)this.value);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                buffer.putLong((Long)this.value);
                break;
            }
            case FLOAT: {
                buffer.putFloat(((Float)this.value).floatValue());
                break;
            }
            case DOUBLE: {
                buffer.putDouble((Double)this.value);
                break;
            }
            case DATE: {
                buffer.putLong(((LocalDate)this.value).toEpochDay());
                break;
            }
            case TEXT: 
            case STRING: {
                byte[] bytes = ((String)this.value).getBytes();
                buffer.putInt(bytes.length);
                buffer.put(bytes);
                break;
            }
            case BLOB: {
                byte[] bytes = ((Binary)this.value).getValues();
                buffer.putInt(bytes.length);
                buffer.put(bytes);
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public void serialize(DataOutputStream buffer) throws IOException {
        buffer.writeInt(Argument.ArgumentType.SCALAR_ARGUMENT.ordinal());
        buffer.writeByte(this.type.getType());
        switch (this.type) {
            case BOOLEAN: {
                buffer.writeByte(((Byte)this.value).byteValue());
                break;
            }
            case INT32: {
                buffer.writeInt((Integer)this.value);
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                buffer.writeLong((Long)this.value);
                break;
            }
            case FLOAT: {
                buffer.writeFloat(((Float)this.value).floatValue());
                break;
            }
            case DOUBLE: {
                buffer.writeDouble((Double)this.value);
                break;
            }
            case DATE: {
                buffer.writeLong(((LocalDate)this.value).toEpochDay());
                break;
            }
            case TEXT: 
            case STRING: {
                byte[] bytes = ((String)this.value).getBytes();
                buffer.writeInt(bytes.length);
                buffer.write(bytes);
                break;
            }
            case BLOB: {
                byte[] bytes = ((Binary)this.value).getValues();
                buffer.writeInt(bytes.length);
                buffer.write(bytes);
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + (Object)((Object)this.type));
            }
        }
    }

    public static ScalarArgument deserialize(ByteBuffer buffer) {
        Type type = Type.valueOf(buffer.get());
        switch (type) {
            case BOOLEAN: {
                return new ScalarArgument(type, buffer.get() != 0);
            }
            case INT32: {
                return new ScalarArgument(type, buffer.getInt());
            }
            case INT64: 
            case TIMESTAMP: {
                return new ScalarArgument(type, buffer.getLong());
            }
            case FLOAT: {
                return new ScalarArgument(type, Float.valueOf(buffer.getFloat()));
            }
            case DOUBLE: {
                return new ScalarArgument(type, buffer.getDouble());
            }
            case DATE: {
                return new ScalarArgument(type, LocalDate.ofEpochDay(buffer.getLong()));
            }
            case BLOB: {
                byte[] bytes = new byte[buffer.getInt()];
                buffer.get(bytes);
                return new ScalarArgument(type, new Binary(bytes));
            }
            case TEXT: 
            case STRING: {
                byte[] bytes = new byte[buffer.getInt()];
                buffer.get(bytes);
                return new ScalarArgument(type, new String(bytes));
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }
}

