/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.cli.utils.CliContext;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.tool.data.ImportData;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.DateUtils;

public abstract class AbstractCli {
    static final String HOST_ARGS = "h";
    static final String HOST_NAME = "host";
    static final String HELP_ARGS = "help";
    static final String PORT_ARGS = "p";
    static final String PORT_NAME = "port";
    static final String PW_ARGS = "pw";
    private static final String PW_NAME = "password";
    static final String USERNAME_ARGS = "u";
    static final String USERNAME_NAME = "username";
    private static final String EXECUTE_ARGS = "e";
    static final String USE_SSL_ARGS = "usessl";
    static final String TRUST_STORE_ARGS = "ts";
    static final String TRUST_STORE_PWD_ARGS = "tpw";
    private static final String EXECUTE_NAME = "execute";
    private static final String USE_SSL = "use_ssl";
    private static final String TRUST_STORE = "trust_store";
    private static final String TRUST_STORE_PWD = "trust_store_pwd";
    private static final String NULL = "null";
    static final int CODE_OK = 0;
    static final int CODE_ERROR = 1;
    static final String ISO8601_ARGS = "disableISO8601";
    static final List<String> AGGREGRATE_TIME_LIST = new ArrayList<String>();
    static final String RPC_COMPRESS_ARGS = "c";
    private static final String RPC_COMPRESS_NAME = "rpcCompressed";
    static final String TIMEOUT_ARGS = "timeout";
    private static final String TIMEOUT_NAME = "queryTimeout";
    static final String SET_TIMESTAMP_DISPLAY = "set time_display_type";
    static final String SHOW_TIMESTAMP_DISPLAY = "show time_display_type";
    static final String SET_TIME_ZONE = "set time_zone";
    static final String SHOW_TIMEZONE = "show time_zone";
    static final String SET_FETCH_SIZE = "set fetch_size";
    static final String SHOW_FETCH_SIZE = "show fetch_size";
    private static final String HELP = "help";
    static final String IOTDB = "IoTDB";
    static String cliPrefix = "IoTDB";
    static final String SCRIPT_HINT = "./start-cli.sh(start-cli.bat if Windows)";
    static final String QUIT_COMMAND = "quit";
    static final String EXIT_COMMAND = "exit";
    private static final String SHOW_METADATA_COMMAND = "show timeseries";
    static final int MAX_HELP_CONSOLE_WIDTH = 88;
    static final String TIMESTAMP_STR = "Time";
    private static final String IMPORT_CMD = "import";
    static int maxPrintRowCount = 1000;
    private static int fetchSize = 1000;
    static int queryTimeout = 0;
    static String timestampPrecision = "ms";
    static String timeFormat = "default";
    private static boolean continuePrint = false;
    private static int lineCount = 0;
    private static final String SUCCESS_MESSAGE = "The statement is executed successfully.";
    private static boolean isReachEnd = false;
    static String host = "127.0.0.1";
    static String port = "6667";
    static String username;
    static String password;
    static String useSsl;
    static String trustStore;
    static String trustStorePwd;
    static String execute;
    static boolean hasExecuteSQL;
    static Set<String> keywordSet;
    static ServerProperties properties;
    private static boolean cursorBeforeFirst;
    static int lastProcessStatus;
    static String sqlDialect;
    static String usingDatabase;

    static void init() {
        keywordSet.add("-h");
        keywordSet.add("-help");
        keywordSet.add("-p");
        keywordSet.add("-pw");
        keywordSet.add("-u");
        keywordSet.add("-usessl");
        keywordSet.add("-ts");
        keywordSet.add("-tpw");
        keywordSet.add("-e");
        keywordSet.add("-disableISO8601");
        keywordSet.add("-c");
    }

    static Options createOptions() {
        Options options = new Options();
        Option help = new Option("help", false, "Display help information. (optional)");
        help.setRequired(false);
        options.addOption(help);
        Option timeFormat = new Option(ISO8601_ARGS, false, "Display timestamp in numeric format. (optional)");
        timeFormat.setRequired(false);
        options.addOption(timeFormat);
        Option host = Option.builder((String)HOST_ARGS).argName(HOST_NAME).hasArg().desc("Host Name. Default is 127.0.0.1. (optional)").build();
        options.addOption(host);
        Option port = Option.builder((String)PORT_ARGS).argName(PORT_NAME).hasArg().desc("Port. Default is 6667. (optional)").build();
        options.addOption(port);
        Option username = Option.builder((String)USERNAME_ARGS).argName(USERNAME_NAME).hasArg().desc("User name. (required)").required().build();
        options.addOption(username);
        Option password = Option.builder((String)PW_ARGS).argName(PW_NAME).hasArg().desc("Password. Default is root. (optional)").build();
        options.addOption(password);
        Option useSSL = Option.builder((String)USE_SSL_ARGS).argName(USE_SSL).hasArg().desc("Use SSL statement. (optional)").build();
        options.addOption(useSSL);
        Option trustStore = Option.builder((String)TRUST_STORE_ARGS).argName(TRUST_STORE).hasArg().desc("Trust store statement. (optional)").build();
        options.addOption(trustStore);
        Option trustStorePwd = Option.builder((String)TRUST_STORE_PWD_ARGS).argName(TRUST_STORE_PWD).hasArg().desc("Trust store password statement. (optional)").build();
        options.addOption(trustStorePwd);
        Option execute = Option.builder((String)EXECUTE_ARGS).argName(EXECUTE_NAME).hasArg().desc("Execute a statement. (optional)").build();
        options.addOption(execute);
        Option isRpcCompressed = Option.builder((String)RPC_COMPRESS_ARGS).argName(RPC_COMPRESS_NAME).desc("Enable or disable Rpc Compression. (optional)").build();
        options.addOption(isRpcCompressed);
        Option queryTimeout = Option.builder((String)TIMEOUT_ARGS).argName(TIMEOUT_NAME).hasArg().desc("The timeout in seconds. Uses the server configuration if not set. (optional)").build();
        options.addOption(queryTimeout);
        Option sqlDialect = Option.builder((String)"sql_dialect").argName("sql_dialect").hasArg().desc("Currently supports tree and table; uses tree if not set. (optional)").build();
        options.addOption(sqlDialect);
        return options;
    }

    static String checkRequiredArg(CliContext ctx, String arg, String name, CommandLine commandLine, boolean isRequired, String defaultValue) throws ArgsErrorException {
        String str = commandLine.getOptionValue(arg);
        if (str == null) {
            if (isRequired) {
                String msg = String.format("%s: Required values for option '%s' not provided", IOTDB, name);
                ctx.getPrinter().println(msg);
                ctx.getPrinter().println("Use -help for more information");
                throw new ArgsErrorException(msg);
            }
            if (defaultValue == null) {
                String msg = String.format("%s: Required values for option '%s' is null.", IOTDB, name);
                throw new ArgsErrorException(msg);
            }
            return defaultValue;
        }
        return str;
    }

    private static void setFetchSize(String fetchSizeString) {
        long tmp = Long.parseLong(fetchSizeString.trim());
        fetchSize = tmp > Integer.MAX_VALUE || tmp < 0L ? Integer.MAX_VALUE : Integer.parseInt(fetchSizeString.trim());
    }

    private static int setFetchSize(CliContext ctx, String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            ctx.getPrinter().println(String.format("Fetch size format error, please input like %s=10000", SET_FETCH_SIZE));
            return 1;
        }
        try {
            AbstractCli.setFetchSize(cmd.split("=")[1]);
        }
        catch (Exception e) {
            ctx.getPrinter().println(String.format("Fetch size format error, %s", e.getMessage()));
            return 1;
        }
        ctx.getPrinter().println("Fetch size has set to " + values[1].trim());
        return 0;
    }

    static void setQueryTimeout(String timeoutString) {
        long timeout = Long.parseLong(timeoutString.trim());
        queryTimeout = timeout > Integer.MAX_VALUE || timeout < 0L ? 0 : Integer.parseInt(timeoutString.trim());
    }

    static void setSqlDialect(String sqlDialect) {
        AbstractCli.sqlDialect = sqlDialect;
    }

    static String[] removePasswordArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-pw")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        return args;
    }

    static String[] processExecuteArgs(String[] args) {
        int index = -1;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-e")) continue;
            index = i;
            break;
        }
        if (index >= 0 && (index + 1 >= args.length || index + 1 < args.length && keywordSet.contains(args[index + 1]))) {
            return (String[])ArrayUtils.remove((Object[])args, (int)index);
        }
        if (index == -1) {
            return args;
        }
        StringBuilder executeCommand = new StringBuilder();
        for (int j = index + 1; j < args.length; ++j) {
            executeCommand.append(args[j]).append(" ");
        }
        executeCommand.deleteCharAt(executeCommand.length() - 1);
        if (executeCommand.charAt(0) == '\'' || executeCommand.charAt(0) == '\"') {
            executeCommand.deleteCharAt(0);
            if (executeCommand.charAt(executeCommand.length() - 1) == '\'' || executeCommand.charAt(executeCommand.length() - 1) == '\"') {
                executeCommand.deleteCharAt(executeCommand.length() - 1);
            }
        }
        execute = executeCommand.toString();
        hasExecuteSQL = true;
        continuePrint = true;
        args = Arrays.copyOfRange(args, 0, index);
        return args;
    }

    static void displayLogo(CliContext ctx, String logo, String version, String buildInfo) {
        ctx.getPrinter().println((logo != null ? logo : " _____       _________  ______   ______    \n|_   _|     |  _   _  ||_   _ `.|_   _ \\   \n  | |   .--.|_/ | | \\_|  | | `. \\ | |_) |  \n  | | / .'`\\ \\  | |      | |  | | |  __'.  \n _| |_| \\__. | _| |_    _| |_.' /_| |__) | \n|_____|'.__.' |_____|  |______.'|_______/  ") + "version " + version + " (Build: " + (buildInfo != null ? buildInfo : "UNKNOWN") + ")\n                                           \n");
    }

    static void echoStarting(CliContext ctx) {
        ctx.getPrinter().println("---------------------");
        ctx.getPrinter().println("Starting IoTDB Cli");
        ctx.getPrinter().println("---------------------");
    }

    static OperationResult handleInputCmd(CliContext ctx, String cmd, IoTDBConnection connection) {
        lastProcessStatus = 0;
        String specialCmd = cmd.toLowerCase().trim();
        if (QUIT_COMMAND.equals(specialCmd) || EXIT_COMMAND.equals(specialCmd)) {
            return OperationResult.STOP_OPER;
        }
        if ("help".equals(specialCmd)) {
            AbstractCli.showHelp(ctx);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIMESTAMP_DISPLAY)) {
            lastProcessStatus = AbstractCli.setTimestampDisplay(ctx, specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_TIME_ZONE)) {
            lastProcessStatus = AbstractCli.setTimeZone(ctx, specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SET_FETCH_SIZE)) {
            lastProcessStatus = AbstractCli.setFetchSize(ctx, specialCmd, cmd);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMEZONE)) {
            lastProcessStatus = AbstractCli.showTimeZone(ctx, connection);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_TIMESTAMP_DISPLAY)) {
            ctx.getPrinter().println("Current time format: " + timeFormat);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(SHOW_FETCH_SIZE)) {
            ctx.getPrinter().println("Current fetch size: " + fetchSize);
            return OperationResult.CONTINUE_OPER;
        }
        if (specialCmd.startsWith(IMPORT_CMD)) {
            lastProcessStatus = AbstractCli.importCmd(ctx, specialCmd, cmd, connection);
            return OperationResult.CONTINUE_OPER;
        }
        lastProcessStatus = AbstractCli.executeQuery(ctx, connection, cmd);
        return OperationResult.NO_OPER;
    }

    private static void showHelp(CliContext ctx) {
        ctx.getPrinter().println("    <your-sql>\t\t\t execute your sql statment");
        ctx.getPrinter().println(String.format("    %s\t\t show how many timeseries are in iotdb", SHOW_METADATA_COMMAND));
        ctx.getPrinter().println(String.format("    %s=xxx\t eg. long, default, ISO8601, yyyy-MM-dd HH:mm:ss.", SET_TIMESTAMP_DISPLAY));
        ctx.getPrinter().println(String.format("    %s\t show time display type", SHOW_TIMESTAMP_DISPLAY));
        ctx.getPrinter().println(String.format("    %s=xxx\t\t eg. +08:00, Asia/Shanghai.", SET_TIME_ZONE));
        ctx.getPrinter().println(String.format("    %s\t\t show cli time zone", SHOW_TIMEZONE));
        ctx.getPrinter().println(String.format("    %s=xxx\t\t set fetch size when querying data from server.", SET_FETCH_SIZE));
        ctx.getPrinter().println(String.format("    %s\t\t show fetch size", SHOW_FETCH_SIZE));
    }

    private static int setTimestampDisplay(CliContext ctx, String specialCmd, String cmd) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            ctx.getPrinter().println(String.format("Time display format error, please input like %s=ISO8601", SET_TIMESTAMP_DISPLAY));
            return 1;
        }
        try {
            timeFormat = RpcUtils.setTimeFormat((String)cmd.split("=")[1]);
        }
        catch (Exception e) {
            ctx.getPrinter().println(String.format("time display format error, %s", e.getMessage()));
            return 1;
        }
        ctx.getPrinter().println("Time display type has set to " + cmd.split("=")[1].trim());
        return 0;
    }

    private static int setTimeZone(CliContext ctx, String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split("=");
        if (values.length != 2) {
            ctx.getPrinter().println(String.format("Time zone format error, please input like %s=+08:00", SET_TIME_ZONE));
            return 1;
        }
        try {
            connection.setTimeZone(cmd.split("=")[1].trim());
        }
        catch (Exception e) {
            ctx.getPrinter().println(String.format("Time zone format error: %s", e.getMessage()));
            return 1;
        }
        ctx.getPrinter().println("Time zone has set to " + values[1].trim());
        return 0;
    }

    private static int showTimeZone(CliContext ctx, IoTDBConnection connection) {
        try {
            ctx.getPrinter().println("Current time zone: " + connection.getTimeZone());
        }
        catch (Exception e) {
            ctx.getPrinter().println("Cannot get time zone from server side because: " + e.getMessage());
            return 1;
        }
        return 0;
    }

    private static int importCmd(CliContext ctx, String specialCmd, String cmd, IoTDBConnection connection) {
        String[] values = specialCmd.split(" ");
        if (values.length != 2) {
            ctx.getPrinter().println("Please input like: import /User/myfile. Noted that your file path cannot contain any space character)");
            return 1;
        }
        ctx.getPrinter().println(cmd.split(" ")[1]);
        try {
            return ImportData.importFromTargetPath(host, Integer.parseInt(port), username, password, cmd.split(" ")[1], connection.getTimeZone());
        }
        catch (IoTDBConnectionException e) {
            ctx.getPrinter().printException((Exception)((Object)e));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int executeQuery(CliContext ctx, IoTDBConnection connection, String cmd) {
        int executeStatus;
        block23: {
            executeStatus = 0;
            long startTime = System.currentTimeMillis();
            try (Statement statement = connection.createStatement();){
                ZoneId zoneId = ZoneId.of(connection.getTimeZone());
                statement.setFetchSize(fetchSize);
                boolean hasResultSet = statement.execute(cmd.trim());
                long costTime = System.currentTimeMillis() - startTime;
                if (hasResultSet) {
                    try (ResultSet resultSet = statement.getResultSet();){
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        int columnLength = resultSetMetaData.getColumnCount();
                        ArrayList<Integer> maxSizeList = new ArrayList<Integer>(columnLength);
                        List<List<String>> lists = AbstractCli.cacheResult(ctx, resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                        AbstractCli.output(ctx, lists, maxSizeList);
                        ctx.getPrinter().println(String.format("It costs %.3fs", (double)costTime / 1000.0));
                        while (!isReachEnd) {
                            if (continuePrint) {
                                maxSizeList = new ArrayList(columnLength);
                                lists = AbstractCli.cacheResult(ctx, resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                                AbstractCli.output(ctx, lists, maxSizeList);
                                continue;
                            }
                            ctx.getPrinter().println("This display 1000 rows. Press ENTER to show more, input 'q' to quit.");
                            BufferedReader br = new BufferedReader(new InputStreamReader(ctx.getIn()));
                            try {
                                String line = ctx.isDisableCliHistory() ? ctx.getLineReader().readLine() : br.readLine();
                                if (!"".equals(line)) break;
                                maxSizeList = new ArrayList(columnLength);
                                lists = AbstractCli.cacheResult(ctx, resultSet, maxSizeList, columnLength, resultSetMetaData, zoneId);
                                AbstractCli.output(ctx, lists, maxSizeList);
                            }
                            catch (Exception e) {
                                ctx.getPrinter().printException(e);
                                executeStatus = 1;
                            }
                        }
                        if (((IoTDBJDBCResultSet)resultSet).isSetTracingInfo()) {
                            maxSizeList = new ArrayList(2);
                            lists = AbstractCli.cacheTracingInfo(resultSet, maxSizeList);
                            AbstractCli.outputTracingInfo(ctx, lists, maxSizeList);
                        }
                        break block23;
                    }
                }
                ctx.getPrinter().println("Msg: The statement is executed successfully.");
            }
            catch (Exception e) {
                ctx.getPrinter().println("Msg: " + e);
                executeStatus = 1;
            }
            finally {
                AbstractCli.updateSqlDialectAndUsingDatabase(connection.getParams().getSqlDialect(), connection.getParams().getDb().orElse(null));
                AbstractCli.resetArgs();
            }
        }
        return executeStatus;
    }

    private static List<List<String>> cacheResult(CliContext ctx, ResultSet resultSet, List<Integer> maxSizeList, int columnCount, ResultSetMetaData resultSetMetaData, ZoneId zoneId) throws SQLException {
        int i;
        int j = 0;
        if (cursorBeforeFirst) {
            isReachEnd = !resultSet.next();
            cursorBeforeFirst = false;
        }
        ArrayList<List<String>> lists = new ArrayList<List<String>>(columnCount);
        int endTimeIndex = -1;
        if (resultSet instanceof IoTDBJDBCResultSet) {
            boolean printTimestamp;
            for (int i2 = 1; i2 <= columnCount; ++i2) {
                ArrayList<String> list = new ArrayList<String>(maxPrintRowCount + 1);
                String columnLabel = resultSetMetaData.getColumnLabel(i2);
                if (columnLabel.equalsIgnoreCase("__endTime")) {
                    endTimeIndex = i2;
                }
                list.add(columnLabel);
                lists.add(list);
                int count = ctx.getPrinter().computeHANCount(columnLabel);
                maxSizeList.add(columnLabel.length() + count);
            }
            IoTDBJDBCResultSet ioTDBJDBCResultSet = (IoTDBJDBCResultSet)resultSet;
            boolean bl = printTimestamp = !ioTDBJDBCResultSet.isIgnoreTimeStamp();
            while (j < maxPrintRowCount && !isReachEnd) {
                for (int i3 = 1; i3 <= columnCount; ++i3) {
                    String tmp = printTimestamp && i3 == 1 ? RpcUtils.formatDatetime((String)timeFormat, (String)timestampPrecision, (long)resultSet.getLong(TIMESTAMP_STR), (ZoneId)zoneId) : (endTimeIndex == i3 ? RpcUtils.formatDatetime((String)timeFormat, (String)timestampPrecision, (long)resultSet.getLong(i3), (ZoneId)zoneId) : AbstractCli.getStringByColumnIndex(ioTDBJDBCResultSet, i3, zoneId));
                    if (tmp == null) {
                        tmp = NULL;
                    }
                    ((List)lists.get(i3 - 1)).add(tmp);
                    int count = ctx.getPrinter().computeHANCount(tmp);
                    int realLength = tmp.length() + count;
                    if (maxSizeList.get(i3 - 1) >= realLength) continue;
                    maxSizeList.set(i3 - 1, realLength);
                }
                ++j;
                isReachEnd = !resultSet.next();
            }
            return lists;
        }
        for (i = 1; i <= columnCount; i += 2) {
            ArrayList<String> timeList = new ArrayList<String>(maxPrintRowCount + 1);
            timeList.add(resultSetMetaData.getColumnLabel(i).substring(0, TIMESTAMP_STR.length()));
            lists.add(timeList);
            ArrayList<String> valueList = new ArrayList<String>(maxPrintRowCount + 1);
            valueList.add(resultSetMetaData.getColumnLabel(i + 1));
            lists.add(valueList);
            maxSizeList.add(TIMESTAMP_STR.length());
            maxSizeList.add(resultSetMetaData.getColumnLabel(i + 1).length());
        }
        while (j < maxPrintRowCount && !isReachEnd) {
            for (i = 1; i <= columnCount; ++i) {
                String tmp = resultSet.getString(i);
                if (tmp == null) {
                    tmp = NULL;
                }
                if (i % 2 != 0 && !tmp.equals(NULL)) {
                    tmp = RpcUtils.formatDatetime((String)timeFormat, (String)timestampPrecision, (long)Long.parseLong(tmp), (ZoneId)zoneId);
                }
                ((List)lists.get(i - 1)).add(tmp);
                if (maxSizeList.get(i - 1) >= tmp.length()) continue;
                maxSizeList.set(i - 1, tmp.length());
            }
            ++j;
            isReachEnd = !resultSet.next();
        }
        return lists;
    }

    private static String getStringByColumnIndex(IoTDBJDBCResultSet resultSet, int columnIndex, ZoneId zoneId) throws SQLException {
        TSDataType type = resultSet.getColumnTypeByIndex(columnIndex);
        switch (type) {
            case BOOLEAN: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case TEXT: 
            case STRING: {
                return resultSet.getString(columnIndex);
            }
            case BLOB: {
                byte[] v = resultSet.getBytes(columnIndex);
                if (v == null) {
                    return null;
                }
                return BytesUtils.parseBlobByteArrayToString((byte[])v);
            }
            case DATE: {
                int intValue = resultSet.getInt(columnIndex);
                if (resultSet.wasNull()) {
                    return null;
                }
                return DateUtils.formatDate((int)intValue);
            }
            case TIMESTAMP: {
                long longValue = resultSet.getLong(columnIndex);
                if (resultSet.wasNull()) {
                    return null;
                }
                return RpcUtils.formatDatetime((String)timeFormat, (String)timestampPrecision, (long)longValue, (ZoneId)zoneId);
            }
        }
        return null;
    }

    private static List<List<String>> cacheTracingInfo(ResultSet resultSet, List<Integer> maxSizeList) throws Exception {
        ArrayList<List<String>> lists = new ArrayList<List<String>>(2);
        lists.add(0, new ArrayList());
        lists.add(1, new ArrayList());
        String activityStr = "Activity";
        String elapsedTimeStr = "Elapsed Time";
        ((List)lists.get(0)).add(activityStr);
        ((List)lists.get(1)).add(elapsedTimeStr);
        maxSizeList.add(0, activityStr.length());
        maxSizeList.add(1, elapsedTimeStr.length());
        List activityList = ((IoTDBJDBCResultSet)resultSet).getActivityList();
        List elapsedTimeList = ((IoTDBJDBCResultSet)resultSet).getElapsedTimeList();
        String[] statisticsInfoList = new String[]{"seriesPathNum", "seqFileNum", "unSeqFileNum", "seqChunkInfo", "unSeqChunkInfo", "pageNumInfo"};
        for (int i = 0; i < activityList.size(); ++i) {
            if (i == activityList.size() - 1) {
                for (String infoName : statisticsInfoList) {
                    String info = ((IoTDBJDBCResultSet)resultSet).getStatisticsInfoByName(infoName);
                    ((List)lists.get(0)).add(info);
                    ((List)lists.get(1)).add("");
                    if (info.length() <= maxSizeList.get(0)) continue;
                    maxSizeList.set(0, info.length());
                }
            }
            String activity = (String)activityList.get(i);
            String elapsedTime = ((Long)elapsedTimeList.get(i)).toString();
            if (activity.length() > maxSizeList.get(0)) {
                maxSizeList.set(0, activity.length());
            }
            if (elapsedTime.length() > maxSizeList.get(1)) {
                maxSizeList.set(1, elapsedTime.length());
            }
            ((List)lists.get(0)).add(activity);
            ((List)lists.get(1)).add(elapsedTime);
        }
        return lists;
    }

    private static void output(CliContext ctx, List<List<String>> lists, List<Integer> maxSizeList) {
        ctx.getPrinter().printBlockLine(maxSizeList);
        ctx.getPrinter().printRow(lists, 0, maxSizeList);
        ctx.getPrinter().printBlockLine(maxSizeList);
        if (!lists.isEmpty()) {
            for (int i = 1; i < lists.get(0).size(); ++i) {
                ctx.getPrinter().printRow(lists, i, maxSizeList);
            }
        }
        ctx.getPrinter().printBlockLine(maxSizeList);
        if (isReachEnd) {
            ctx.getPrinter().printCount(lineCount += lists.isEmpty() ? 0 : lists.get(0).size() - 1);
        } else {
            lineCount += maxPrintRowCount;
        }
    }

    private static void outputTracingInfo(CliContext ctx, List<List<String>> lists, List<Integer> maxSizeList) {
        ctx.getPrinter().println();
        ctx.getPrinter().println("Tracing Activities:");
        ctx.getPrinter().printBlockLine(maxSizeList);
        ctx.getPrinter().printRow(lists, 0, maxSizeList);
        ctx.getPrinter().printBlockLine(maxSizeList);
        for (int i = 1; i < lists.get(0).size(); ++i) {
            ctx.getPrinter().printRow(lists, i, maxSizeList);
        }
        ctx.getPrinter().printBlockLine(maxSizeList);
    }

    private static void resetArgs() {
        lineCount = 0;
        cursorBeforeFirst = true;
        isReachEnd = false;
    }

    static boolean processCommand(CliContext ctx, String s, IoTDBConnection connection) {
        String[] cmds;
        if (s == null) {
            return true;
        }
        block4: for (String cmd : cmds = s.trim().split(";")) {
            if (cmd == null || "".equals(cmd.trim())) continue;
            OperationResult result = AbstractCli.handleInputCmd(ctx, cmd, connection);
            switch (result) {
                case STOP_OPER: {
                    return false;
                }
                case CONTINUE_OPER: {
                    continue block4;
                }
            }
        }
        return true;
    }

    private static void updateSqlDialectAndUsingDatabase(String sqlDialectOfConnection, String databaseOfConnection) {
        boolean needUpdateCliPrefix = !Objects.equals(sqlDialect, sqlDialectOfConnection) || !Objects.equals(usingDatabase, databaseOfConnection);
        sqlDialect = sqlDialectOfConnection;
        usingDatabase = databaseOfConnection;
        if (needUpdateCliPrefix) {
            cliPrefix = IOTDB;
            if (sqlDialect != null && Model.TABLE.name().equals(sqlDialect.toUpperCase()) && databaseOfConnection != null) {
                cliPrefix = cliPrefix + ":" + databaseOfConnection;
            }
        }
    }

    static {
        hasExecuteSQL = false;
        keywordSet = new HashSet<String>();
        properties = null;
        cursorBeforeFirst = true;
        lastProcessStatus = 0;
        sqlDialect = "tree";
        usingDatabase = null;
    }

    static enum OperationResult {
        STOP_OPER,
        CONTINUE_OPER,
        NO_OPER;

    }
}

