/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.multimap.AbstractMutableMultimap;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;

public abstract class AbstractSynchronizedPutMultimap<K, V, C extends MutableCollection<V>>
extends AbstractMutableMultimap<K, V, C> {
    private final AtomicInteger atomicTotalSize = new AtomicInteger(0);

    protected AbstractSynchronizedPutMultimap() {
    }

    protected AbstractSynchronizedPutMultimap(MutableMap<K, C> newMap) {
        super(newMap);
    }

    @Override
    protected MutableMap<K, C> createMap() {
        return ConcurrentHashMap.newMap();
    }

    @Override
    protected MutableMap<K, C> createMapWithKeyCount(int keyCount) {
        return ConcurrentHashMap.newMap(keyCount);
    }

    @Override
    public int size() {
        return this.atomicTotalSize.get();
    }

    @Override
    protected void incrementTotalSize() {
        this.atomicTotalSize.incrementAndGet();
    }

    @Override
    protected void decrementTotalSize() {
        this.atomicTotalSize.decrementAndGet();
    }

    @Override
    protected void addToTotalSize(int value) {
        this.atomicTotalSize.addAndGet(value);
    }

    @Override
    protected void subtractFromTotalSize(int value) {
        this.atomicTotalSize.addAndGet(-value);
    }

    @Override
    protected void clearTotalSize() {
        this.atomicTotalSize.set(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(K key, V value) {
        C collection;
        C c = collection = this.getIfAbsentPutCollection(key);
        synchronized (c) {
            if (collection.add(value)) {
                this.incrementTotalSize();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableMultimap<K, V> withKeyMultiValues(K key, V ... values) {
        Objects.requireNonNull(values);
        if (values.length > 0) {
            C existingValues;
            C c = existingValues = this.getIfAbsentPutCollection(key);
            synchronized (c) {
                this.addAll(existingValues, values);
                return this;
            }
        }
        return this;
    }

    private void addAll(C existingValues, V[] values) {
        int currentSize = existingValues.size();
        int newSize = ((MutableCollection)ArrayIterate.addAllTo(values, existingValues)).size();
        this.addToTotalSize(newSize - currentSize);
    }

    private C getIfAbsentPutCollection(K key) {
        return (C)((MutableCollection)this.map.getIfAbsentPutWith(key, this.createCollectionBlock(), this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C getIfAbsentPutAll(K key, Iterable<? extends V> values) {
        C existingValues;
        if (Iterate.isEmpty(values)) {
            return (C)this.get((Object)key);
        }
        C c = existingValues = this.getIfAbsentPutCollection(key);
        synchronized (c) {
            if (existingValues.isEmpty()) {
                int newSize = ((MutableCollection)Iterate.addAllTo(values, existingValues)).size();
                this.addToTotalSize(newSize);
            }
            return (C)existingValues.asUnmodifiable();
        }
    }
}

