/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.path.PathPatternTreeUtils;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CountStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class CountDevicesStatement
extends CountStatement {
    WhereCondition timeCondition;

    public CountDevicesStatement(PartialPath partialPath) {
        super(partialPath);
    }

    public void setTimeCondition(WhereCondition timeCondition) {
        this.timeCondition = timeCondition;
    }

    public WhereCondition getTimeCondition() {
        return this.timeCondition;
    }

    public boolean hasTimeCondition() {
        return this.timeCondition != null;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (this.hasTimeCondition()) {
            try {
                if (!AuthorityChecker.SUPER_USER.equals(userName)) {
                    this.authorityScope = PathPatternTreeUtils.intersectWithFullPathPrefixTree((PathPatternTree)AuthorityChecker.getAuthorizedPathTree(userName, PrivilegeType.READ_SCHEMA.ordinal()), (PathPatternTree)AuthorityChecker.getAuthorizedPathTree(userName, PrivilegeType.READ_DATA.ordinal()));
                }
            }
            catch (AuthException e) {
                return new TSStatus(e.getCode().getStatusCode());
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return super.checkPermissionBeforeProcess(userName);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCountDevices(this, context);
    }
}

