/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Pair;

public class DataNodeQueryContext {
    @GuardedBy(value="lock")
    private final Map<PartialPath, Pair<AtomicInteger, TimeValuePair>> uncachedPathToSeriesScanInfo;
    private final AtomicInteger dataNodeFINum;
    private final ReentrantLock lock = new ReentrantLock();

    public DataNodeQueryContext(int dataNodeFINum) {
        this.uncachedPathToSeriesScanInfo = new HashMap<PartialPath, Pair<AtomicInteger, TimeValuePair>>();
        this.dataNodeFINum = new AtomicInteger(dataNodeFINum);
    }

    public boolean unCached(PartialPath path) {
        return this.uncachedPathToSeriesScanInfo.containsKey(path);
    }

    public void addUnCachePath(PartialPath path, AtomicInteger dataNodeSeriesScanNum) {
        this.uncachedPathToSeriesScanInfo.put(path, (Pair<AtomicInteger, TimeValuePair>)new Pair((Object)dataNodeSeriesScanNum, null));
    }

    public Pair<AtomicInteger, TimeValuePair> getSeriesScanInfo(PartialPath path) {
        return this.uncachedPathToSeriesScanInfo.get(path);
    }

    public int decreaseDataNodeFINum() {
        return this.dataNodeFINum.decrementAndGet();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unLock() {
        this.lock.unlock();
    }
}

