/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import reactor.netty.tcp.AbstractProtocolSslContextSpec;

public final class DefaultSslContextSpec
extends AbstractProtocolSslContextSpec<DefaultSslContextSpec> {
    static final Consumer<SslContextBuilder> DEFAULT_CONFIGURATOR = sslCtxBuilder -> {};

    public static DefaultSslContextSpec forClient() {
        return new DefaultSslContextSpec(SslContextBuilder.forClient());
    }

    public static DefaultSslContextSpec forServer(File keyCertChainFile, File keyFile) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile));
    }

    public static DefaultSslContextSpec forServer(File keyCertChainFile, File keyFile, String keyPassword) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((File)keyCertChainFile, (File)keyFile, (String)keyPassword));
    }

    public static DefaultSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((InputStream)keyCertChainInputStream, (InputStream)keyInputStream));
    }

    public static DefaultSslContextSpec forServer(InputStream keyCertChainInputStream, InputStream keyInputStream, String keyPassword) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((InputStream)keyCertChainInputStream, (InputStream)keyInputStream, (String)keyPassword));
    }

    public static DefaultSslContextSpec forServer(KeyManager keyManager) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((KeyManager)keyManager));
    }

    public static DefaultSslContextSpec forServer(KeyManagerFactory keyManagerFactory) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, Iterable<? extends X509Certificate> keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, keyCertChain));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, String keyPassword, Iterable<? extends X509Certificate> keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, keyCertChain));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, String keyPassword, X509Certificate ... keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (String)keyPassword, (X509Certificate[])keyCertChain));
    }

    public static DefaultSslContextSpec forServer(PrivateKey key, X509Certificate ... keyCertChain) {
        return new DefaultSslContextSpec(SslContextBuilder.forServer((PrivateKey)key, (X509Certificate[])keyCertChain));
    }

    DefaultSslContextSpec(SslContextBuilder sslContextBuilder) {
        super(sslContextBuilder);
    }

    @Override
    public DefaultSslContextSpec get() {
        return this;
    }

    @Override
    protected Consumer<SslContextBuilder> defaultConfiguration() {
        return DEFAULT_CONFIGURATOR;
    }
}

