/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.reader.series;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.controller.IChunkLoader;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.chunk.AlignedChunkReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.read.reader.series.AbstractFileSeriesReader;

public class FileSeriesReader
extends AbstractFileSeriesReader {
    public FileSeriesReader(IChunkLoader chunkLoader, List<IChunkMetadata> chunkMetadataList, Filter filter) {
        super(chunkLoader, chunkMetadataList, filter);
    }

    @Override
    protected void initChunkReader(IChunkMetadata chunkMetaData) throws IOException {
        this.currentChunkMeasurementNames.clear();
        if (chunkMetaData instanceof ChunkMetadata) {
            Chunk chunk = this.chunkLoader.loadChunk((ChunkMetadata)chunkMetaData);
            this.chunkReader = new ChunkReader(chunk, this.filter);
            this.currentChunkMeasurementNames.add(chunkMetaData.getMeasurementUid());
        } else {
            AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetaData;
            Chunk timeChunk = this.chunkLoader.loadChunk((ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata());
            ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
            for (IChunkMetadata metadata : alignedChunkMetadata.getValueChunkMetadataList()) {
                if (metadata != null) {
                    valueChunkList.add(this.chunkLoader.loadChunk((ChunkMetadata)metadata));
                    this.currentChunkMeasurementNames.add(metadata.getMeasurementUid());
                    continue;
                }
                valueChunkList.add(null);
                this.currentChunkMeasurementNames.add(null);
            }
            this.chunkReader = new AlignedChunkReader(timeChunk, valueChunkList, this.filter);
        }
    }

    @Override
    protected boolean chunkCanSkip(IChunkMetadata chunkMetaData) {
        return this.filter != null && this.filter.canSkip(chunkMetaData);
    }
}

