/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ParsingResult;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataSet;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class QueryFirstResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=616");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=618");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=617");
    private final ResponseHeader responseHeader;
    private final QueryDataSet[] queryDataSets;
    private final ByteString continuationPoint;
    private final ParsingResult[] parsingResults;
    private final DiagnosticInfo[] diagnosticInfos;
    private final ContentFilterResult filterResult;

    public QueryFirstResponse(ResponseHeader responseHeader, QueryDataSet[] queryDataSets, ByteString continuationPoint, ParsingResult[] parsingResults, DiagnosticInfo[] diagnosticInfos, ContentFilterResult filterResult) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSets;
        this.continuationPoint = continuationPoint;
        this.parsingResults = parsingResults;
        this.diagnosticInfos = diagnosticInfos;
        this.filterResult = filterResult;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public QueryDataSet[] getQueryDataSets() {
        return this.queryDataSets;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public ParsingResult[] getParsingResults() {
        return this.parsingResults;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public ContentFilterResult getFilterResult() {
        return this.filterResult;
    }

    protected QueryFirstResponse(QueryFirstResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((QueryFirstResponseBuilder)b).responseHeader;
        this.queryDataSets = ((QueryFirstResponseBuilder)b).queryDataSets;
        this.continuationPoint = ((QueryFirstResponseBuilder)b).continuationPoint;
        this.parsingResults = ((QueryFirstResponseBuilder)b).parsingResults;
        this.diagnosticInfos = ((QueryFirstResponseBuilder)b).diagnosticInfos;
        this.filterResult = ((QueryFirstResponseBuilder)b).filterResult;
    }

    public static QueryFirstResponseBuilder<?, ?> builder() {
        return new QueryFirstResponseBuilderImpl();
    }

    public QueryFirstResponseBuilder<?, ?> toBuilder() {
        return new QueryFirstResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryFirstResponse)) {
            return false;
        }
        QueryFirstResponse other = (QueryFirstResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getQueryDataSets(), other.getQueryDataSets())) {
            return false;
        }
        ByteString this$continuationPoint = this.getContinuationPoint();
        ByteString other$continuationPoint = other.getContinuationPoint();
        if (this$continuationPoint == null ? other$continuationPoint != null : !((Object)this$continuationPoint).equals(other$continuationPoint)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getParsingResults(), other.getParsingResults())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDiagnosticInfos(), other.getDiagnosticInfos())) {
            return false;
        }
        ContentFilterResult this$filterResult = this.getFilterResult();
        ContentFilterResult other$filterResult = other.getFilterResult();
        return !(this$filterResult == null ? other$filterResult != null : !((Object)this$filterResult).equals(other$filterResult));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryFirstResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getQueryDataSets());
        ByteString $continuationPoint = this.getContinuationPoint();
        result = result * 59 + ($continuationPoint == null ? 43 : ((Object)$continuationPoint).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParsingResults());
        result = result * 59 + Arrays.deepHashCode(this.getDiagnosticInfos());
        ContentFilterResult $filterResult = this.getFilterResult();
        result = result * 59 + ($filterResult == null ? 43 : ((Object)$filterResult).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "QueryFirstResponse(responseHeader=" + this.getResponseHeader() + ", queryDataSets=" + Arrays.deepToString(this.getQueryDataSets()) + ", continuationPoint=" + this.getContinuationPoint() + ", parsingResults=" + Arrays.deepToString(this.getParsingResults()) + ", diagnosticInfos=" + Arrays.deepToString(this.getDiagnosticInfos()) + ", filterResult=" + this.getFilterResult() + ")";
    }

    private static final class QueryFirstResponseBuilderImpl
    extends QueryFirstResponseBuilder<QueryFirstResponse, QueryFirstResponseBuilderImpl> {
        private QueryFirstResponseBuilderImpl() {
        }

        @Override
        protected QueryFirstResponseBuilderImpl self() {
            return this;
        }

        @Override
        public QueryFirstResponse build() {
            return new QueryFirstResponse(this);
        }
    }

    public static abstract class QueryFirstResponseBuilder<C extends QueryFirstResponse, B extends QueryFirstResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private QueryDataSet[] queryDataSets;
        private ByteString continuationPoint;
        private ParsingResult[] parsingResults;
        private DiagnosticInfo[] diagnosticInfos;
        private ContentFilterResult filterResult;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            QueryFirstResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(QueryFirstResponse instance, QueryFirstResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.queryDataSets(instance.queryDataSets);
            b.continuationPoint(instance.continuationPoint);
            b.parsingResults(instance.parsingResults);
            b.diagnosticInfos(instance.diagnosticInfos);
            b.filterResult(instance.filterResult);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B queryDataSets(QueryDataSet[] queryDataSets) {
            this.queryDataSets = queryDataSets;
            return (B)this.self();
        }

        public B continuationPoint(ByteString continuationPoint) {
            this.continuationPoint = continuationPoint;
            return (B)this.self();
        }

        public B parsingResults(ParsingResult[] parsingResults) {
            this.parsingResults = parsingResults;
            return (B)this.self();
        }

        public B diagnosticInfos(DiagnosticInfo[] diagnosticInfos) {
            this.diagnosticInfos = diagnosticInfos;
            return (B)this.self();
        }

        public B filterResult(ContentFilterResult filterResult) {
            this.filterResult = filterResult;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "QueryFirstResponse.QueryFirstResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", queryDataSets=" + Arrays.deepToString(this.queryDataSets) + ", continuationPoint=" + this.continuationPoint + ", parsingResults=" + Arrays.deepToString(this.parsingResults) + ", diagnosticInfos=" + Arrays.deepToString(this.diagnosticInfos) + ", filterResult=" + this.filterResult + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryFirstResponse> {
        @Override
        public Class<QueryFirstResponse> getType() {
            return QueryFirstResponse.class;
        }

        @Override
        public QueryFirstResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            QueryDataSet[] queryDataSets = (QueryDataSet[])decoder.readStructArray("QueryDataSets", QueryDataSet.TYPE_ID);
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            ParsingResult[] parsingResults = (ParsingResult[])decoder.readStructArray("ParsingResults", ParsingResult.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            ContentFilterResult filterResult = (ContentFilterResult)decoder.readStruct("FilterResult", ContentFilterResult.TYPE_ID);
            return new QueryFirstResponse(responseHeader, queryDataSets, continuationPoint, parsingResults, diagnosticInfos, filterResult);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryFirstResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("QueryDataSets", (Object[])value.getQueryDataSets(), QueryDataSet.TYPE_ID);
            encoder.writeByteString("ContinuationPoint", value.getContinuationPoint());
            encoder.writeStructArray("ParsingResults", (Object[])value.getParsingResults(), ParsingResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
            encoder.writeStruct("FilterResult", (Object)value.getFilterResult(), ContentFilterResult.TYPE_ID);
        }
    }
}

